<?php
// ++=========================================================================++
// || vBadvanced CMPS v3.1.0 (vB 3.6 - vB 3.8) - 82902
// ||  2003-2008 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 08:22, Tue Dec 16th 2008
// || 262082902_405687032856
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

$specialtemplates = array(
	'adv_modules',
	'adv_portal_opts',
	'bbcodecache'
);

switch ($_REQUEST['do'])
{
	case 'menu':
		$phrasegroups = array('cphome');
	break;

	case 'removesetting':
		$phrasegroups = array('cpoption');
	break;

	case 'diagnostics':
		$phrasegroups = array('diagnostic');
	break;

	case 'addmodule':
	case 'editmodule':
	case 'copymodule':
	case 'addpage':
	case 'editpage':
	case 'copypage':
		$phrasegroups[] = 'posting';
	break;
}

if ($_REQUEST['do'] != 'menu')
{
	$phrasegroups[] = 'adv_portal_cp';
}

if (!isset($_REQUEST['do']))
{
	$_REQUEST['do'] = 'frameset';
}

// ##### Preview BB Code Module Ajax ##########################################
if ($_REQUEST['do'] == 'preview')
{
	chdir('../');

	$phrasegroups = array('posting');
	$globaltemplates = array('adv_portal_module_shell');
	$actiontemplates = array();
	$specialtemplates = array();

	require_once('./includes/vba_cmps_include_template.php');

	require_once('./global.php');
	$vbulletin->input->clean_array_gpc('r', array(
		'setting' => TYPE_ARRAY,
		'altshell' => TYPE_STR,
		'customtitle' => TYPE_STR,
		'filename' => TYPE_STR,
		'identifier' => TYPE_STR,
		'message' => TYPE_STR,
		'previewtype' => TYPE_STR,
		'template' => TYPE_STR,
		'templatesused' => TYPE_STR,
		'title' => TYPE_STR,
		'type' => TYPE_STR,

		'html' => TYPE_INT,
		'imgcode' => TYPE_INT,
		'load_bbcode' => TYPE_INT,
		'modid' => TYPE_INT,
		'smilies' => TYPE_INT,
		'useshell' => TYPE_INT
	));

	$previewtype = ($vbulletin->GPC['previewtype'] == 'module') ? 'module' : 'page';
	$modid = $vbulletin->GPC['modid'];

	require_once(DIR . '/includes/class_xml.php');

	// Head include replacements
	$headinclude = str_replace(
		array(
			'"clientscript',
			'url(images/'
		),
		array(
			'"' . $vbulletin->options['bburl'] . '/clientscript',
			'url(' . $vbulletin->options['bburl'] . '/images/'
		),
		$headinclude
	);

	$module_preview = $stylevar['htmldoctype'] . '<html dir="' . $stylevar['textdirection'] . '" lang="' . $stylevar['languagecode'] . '">
	<head>
		' . $headinclude . '
		<title>' . $vbphrase['preview'] . '</title>
	</head>
	<body><div class="page" style="padding: ' . $stylevar['spacersize'] . 'px">';

	// Set $bgclass
	exec_switch_bg();

	$mods['modid'] = $modid;
	$mods['title'] = $vbulletin->GPC['title'];
	$mods['colspan'] = $vbulletin->GPC['colspan'];

	if ($previewtype == 'page')
	{
		if ($vbulletin->GPC['customtitle'])
		{
			$mods['title'] = $vbulletin->GPC['customtitle'];
		}
	}

	if ($vbulletin->GPC['load_bbcode'] OR $vbulletin->GPC['type'] == 'bb_code')
	{
		// Kill the wordwrap setting to avoid problems with HTML links/images
		$vbulletin->options['wordwrap'] = 0;

		// Load BBcode parser
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$vbulletin->vba_bbcode_parser =& $bbcode_parser;
	}

	// Fetch templates
	if ($vbulletin->GPC['type'] == 'php_file' OR ($vbulletin->GPC['type'] == 'template' AND !$vbulletin->GPC['template']))
	{
		$gettemplates = '';

		if ($vbulletin->GPC['type'] == 'template')
		{
			$gettemplates = "'" . $vbulletin->GPC['filename'] . "'";
		}
		else
		{
			$tempsused = explode("\n", $vbulletin->GPC['templatesused']);

			if (!empty($tempsused))
			{
				$gettemplates = "'" . implode("', '", $tempsused) . "'";
			}
		}

		if ($gettemplates)
		{
			$gettemp = $vbulletin->db->query_read("
				SELECT title, template
				FROM " . TABLE_PREFIX . "template
				WHERE title IN($gettemplates)
					AND styleid IN(" . $vbulletin->userinfo['styleid'] . ", -1)
				ORDER BY styleid ASC
			");
			while ($temp = $vbulletin->db->fetch_array($gettemp))
			{
				$vbulletin->templatecache[$temp['title']] = $temp['template'];
			}
		}
	}

	switch ($vbulletin->GPC['type'])
	{
		// ##### Template Module
		case 'template':

			// Template content
			if ($vbulletin->GPC['template'])
			{
				require_once(DIR . '/includes/adminfunctions_template.php');

				$vbulletin->GPC['template'] = compile_template($vbulletin->GPC['template']);
				$templateerrors = check_template_errors($vbulletin->GPC['template']);

				if ($templateerrors)
				{
					$modulehtml = '<em>' . $templateerrors . '</em>';
					$show['tablerow'] = true;
				}
				else
				{
					eval('$modulehtml = "' . $vbulletin->GPC['template'] . '";');
				}
			}
			// Grab the template
			else
			{
				eval('$modulehtml = "' . fetch_template($vbulletin->GPC['filename']) . '";');
			}

		break;

		// ##### PHP File
		case 'php_file':

			// Get the settings
			$cmps_options =& $vbulletin->adv_portal_opts;

			$vba_options = array_merge($cmps_options['adv_portal_main'], $cmps_options['adv_global']);
			$vba_style =& $cmps_options['adv_portal_style'];

			$mod_options =& $cmps_options['adv_portal_' . $vbulletin->GPC['identifier']];

			require_once(DIR . '/includes/vba_cmps_global.php');

			$pagecache =& $vbulletin->adv_portal_page;

			$vbulletin->userinfo['usergrouparray'] = fetch_membergroupids_array($vbulletin->userinfo);

			$modules = array_keys($vbulletin->adv_modules);
			$adv_forumperms = array();
			$adv_canviewforums = array();
			$forumperms_query = '';

			// Current setting values
			if (!empty($vbulletin->GPC['setting']))
			{
				foreach ($vbulletin->GPC['setting'] AS $setting_var => $setting_val)
				{
					$mod_options[$setting_var] = $setting_val;
				}
			}

			if ($vba_options['portal_use_module_function'])
			{
				fetch_vba_module($vbulletin->adv_modules[$mods['modid']]);
			}
			else if ($mods['options'] & $vba_php_modint['clean_output'])
			{
				ob_start();
				require(DIR . '/modules/' . $vbulletin->GPC['filename']);
				$home[$modid]['content'] = ob_get_contents();
				ob_end_clean();
			}
			else
			{
				require(DIR . '/modules/' . $vbulletin->GPC['filename']);
			}

			$modulehtml = $home[$modid]['content'];

		break;

		// ##### BB Code Module
		case 'bb_code':

			if ($vbulletin->GPC['wysiwyg'])
			{
				require_once(DIR . '/includes/functions_wysiwyg.php');
				$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $vbulletin->GPC['html']);
			}

			$modulehtml = $bbcode_parser->do_parse(
				$vbulletin->GPC['message'],
				$vbulletin->GPC['html'],
				$vbulletin->GPC['smilies'],
				1,
				$vbulletin->GPC['imgcode']
			);

			$show['tablerow'] = true;

		break;
	}

	if ($vbulletin->GPC['useshell'] AND !$mods['noshell'])
	{
		eval('$module_preview .= "' . fetch_template(($vbulletin->GPC['altshell'] ? $vbulletin->GPC['altshell'] : 'adv_portal_module_wrapper')) . '";');
	}
	else
	{
		$module_preview .= $modulehtml;
	}

	$module_preview .= '</div></body></html>';

	$xml = new vB_AJAX_XML_Builder($vbulletin, 'text/xml');
	$xml->add_group('data');

	$xml->add_tag(
		'module_preview',
		$module_preview,
		array(),
		true
	);

	$xml->close_group();
	$xml->print_xml();

	exit;
}

require_once('./global.php');
require_once(DIR . '/includes/vba_cmps_adminfunctions.php');

// ##### Build frameset #######################################################
if ($_REQUEST['do'] == 'frameset')
{
	$navframe = '<frame src="vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=menu" name="nav" scrolling="yes" border="no" />';
	$mainframe = '<frame src="vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=main" name="main" scrolling="yes" border="no" />';

	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
	<html dir="' . $stylevar['textdirection'] . '" lang="'. $stylevar['languagecode'] . '">
	<head>
		<title>vBadvanced ' . $vbphrase['admin_control_panel'] . '</title>
		<script type="text/javascript">
		<!-- //
		if (self.parent.frames.length != 0)
		{
			document.write(\'Get me out of this frame set!\');
			self.parent.location.replace(document.location.href);
		}
		// -->
		</script>
	</head>
	<frameset cols="' . iif($stylevar['textdirection'] == 'ltr', '195,*', '*,195') . '" framespacing="0" border="0" frameborder="0" frameborder="no" border="0">
			' . iif($stylevar['textdirection'] == 'ltr', $navframe . $mainframe, $mainframe . $navframe);
	exit;
}

// ##### Nav menu #############################################################
if ($_REQUEST['do'] == 'menu')
{
	require_once(DIR . '/includes/adminfunctions_navpanel.php');
	print_cp_header();

	echo '<div><img alt="" border="" src="../cpstyles/vba_cp_logo.gif" title="' . $vbphrase['admin_control_panel'] . '" hspace="4" vspace="4" /></div><div style="width:168px; padding:4px">';

	echo '<br /><div class="navtitle">' . $vbphrase['vba_cmps'] . '</div><div class="navgroup">';

	construct_nav_option($vbphrase['default_settings'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings');
	construct_nav_option($vbphrase['edit_modules'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listmodules');
	construct_nav_option($vbphrase['add_module'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newmodule');
	construct_nav_option($vbphrase['edit_pages'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listpages');
	construct_nav_option($vbphrase['add_page'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newpage');
	construct_nav_option($vbphrase['download_upload_module'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=download');
	construct_nav_option($vbphrase['quick_permissions_editor'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=permissions');
	construct_nav_option($vbphrase['copy_module_layouts'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=copylayout');
	construct_nav_option($vbphrase['integration'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=integrate');

	foreach ($options AS $links)
	{
		echo $links;
	}
	exit;
}

// ##### Download Module ######################################################
if ($_REQUEST['do'] == 'downloadmodule')
{
	$module = $db->query_first("
		SELECT title, identifier, filename, inctype, templatelist, parent, colspan, formcode, useshell, link, options
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE modid = " . intval($_REQUEST['modid'])
	);

	if (empty($module))
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	$moduleinfo = array(
		'module' => $module,
		'templates' => array()
	);

	// ##### Templates
	if (($module['inctype'] == 'php_file' OR $module['inctype'] == 'template') AND ($module['filename'] OR $module['templatelist']))
	{
		$tnames = ($module['templatelist']) ? explode("\r\n", $module['templatelist']) : array('adv_portal_' . $module['filename']);

		if (!empty($tnames))
		{
			$templates = $db->query_read("
				SELECT title, template_un
				FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode("', '", $tnames) . "')
			");
			while ($temp = $db->fetch_array($templates))
			{
				$moduleinfo['templates'][$temp['title']] = stripslashes($temp['template_un']);
			}
		}
	}

	// ##### PHP File
	if ($module['inctype'] == 'php_file')
	{
		// Get module file
		if ($fp = @fopen('./modules/' . $module['filename'], 'r'))
		{
			$moduleinfo['file'] = fread($fp, filesize('./modules/' . $module['filename']));
			fclose($fp);
		}

		// Settings
		$settingphrase = fetch_settings_phrases();

		$modsettings = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$module[identifier]'");
		while ($setting = $db->fetch_array($modsettings))
		{
			$setting['title'] = $settingphrase['setting_' . $setting['varname'] . '_title'];
			$setting['description'] = $settingphrase['setting_' . $setting['varname'] . '_desc'];
			$moduleinfo['settings'][$setting['varname']] = $setting;
		}
	}

	$filename = strtolower(preg_replace("/[^a-z_0-9]/i", '' , $module['title']));

	// Download XML
	if ($_REQUEST['downloadformat'] == 'xml')
	{
		// ##### Function to loop through the array
		function sort_xml_array($name, $data)
		{
			global $xml;
			if (is_array($data))
			{
				$xml->add_group($name, '');

				foreach ($data AS $name2 => $data2)
				{
					sort_xml_array($name2, $data2);
				}

				$xml->close_group();
			}
			else
			{
				$xml->add_tag($name, $data);
			}
		}

		require_once(DIR . '/includes/class_xml.php');
		$xml = new vB_XML_Builder($vbulletin);

		$xml->add_group('moduleinfo', '');

		foreach ($moduleinfo AS $infokey => $modinfo)
		{
			sort_xml_array($infokey, $modinfo);
		}

		$xml->close_group();

		$moduleinfo = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\r\n";
		$moduleinfo .= $xml->output();

		$filename .= '.xml';
		$content_type = 'text/xml';
	}
	// Download .module
	else
	{
		$moduleinfo = serialize($moduleinfo);
		$filename .= '.module';
		$content_type = 'application/octetstream';
	}

	header('Content-Length: ' . strlen($moduleinfo));
	header('Content-Type: ' . $content_type);
	header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	header('Content-Disposition: attachment; filename="' . $filename . '"');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	header('Pragma: public');

	echo $moduleinfo;
	exit;
}

define('IS_VB_37', (substr($vbulletin->options['templateversion'], 0, 3) == 3.7) ? true : false);

// Grab page/module info
if (isset($_REQUEST['type']))
{
	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);;
}

if ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{
	$module = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE modid = " . intval($_REQUEST['modid']));

	if (!isset($type) AND !isset($_REQUEST['chtype']))
	{
		$type = $module['inctype'];
	}
}

// Query page info
if ($_REQUEST['do'] == 'addpage' OR $_REQUEST['do'] == 'editpage' OR $_REQUEST['do'] == 'copypage')
{
	$pagecache = cache_cmps_pages();

	if ($_REQUEST['do'] != 'addpage')
	{
		$page = $pagecache[$_REQUEST['pageid']];

		if (!isset($_REQUEST['type']) AND !isset($_REQUEST['chtype']))
		{
			$type = $page['type'];
		}
	}
}

$extrahead = '<script type="text/javascript" src="../clientscript/vba_cmps_admin.js"></script>';

if ($type == 'bb_code')
{
	$extrahead .= '<link rel="stylesheet" type="text/css" href="" id="vbulletin_css" />';
}

// Print Admin Header
print_cp_header($vbphrase['vbadvanced_cmps'], '', $extrahead);

if ($_REQUEST['do'] == 'editpage' OR $_REQUEST['do'] == 'addpage' OR $_REQUEST['do'] == 'copypage' OR $_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{
	echo '<script type="text/javascript" src="../clientscript/vbulletin_menu.js"></script>';
	echo '<script type="text/javascript">
<!--
	var is_vb_37 = ' . (IS_VB_37 ? 1 : 0) . ';
-->
</script>';

}

$cmps_options =& $vbulletin->adv_portal_opts;
$vba_options = array_merge($cmps_options['adv_portal_main'], $cmps_options['adv_global']);

require_once(DIR . '/includes/vba_cmps_global.php');

($hook = vBulletinHook::fetch_hook('vba_cmps_admin_global')) ? eval($hook) : false;

// ##### Main admin page ######################################################
if ($_REQUEST['do'] == 'main')
{
	print_form_header('', '');
	print_table_header($vbphrase['welcome_to_vba_cmps_control_panel']);

	$cversion = file_get_contents('http://license.vbadvanced.com/?p=4', 'r');

	print_description_row(iif($cversion,
		construct_phrase(
			$vbphrase['currently_running_latest_available'],
			$vba_options['portal_version'],
			$cversion,
			iif($cversion == $vba_options['portal_version'],
				$vbphrase['your_vba_version_up_to_date'],
				$vbphrase['newer_version_available']
			)
		),
		$vbphrase['version_info_unavailable'])
	);

	print_table_footer();
}

// ##### False action from select boxes
if ($_REQUEST['do'] == 'noaction')
{
	print_stop_message('invalid_action_specified');
}

// ##### Modify Settings ######################################################
if ($_REQUEST['do'] == 'modifysettings')
{
	$grouptitle = $vbulletin->input->clean_gpc('r', 'grouptitle', TYPE_NOHTML);

	$settingphrase = fetch_settings_phrases();

	$grouptitlecache = array();

	// Start printing the settinggroup select box
	$grouptitles = array('all' => '-- ' . $vbphrase['show_all_settings'] . ' --');

	$optionlabel = construct_phrase($vbphrase['x_options'], $vbphrase['default']);

	$modulecache = cache_cmps_modules();

	// Figure out which modules we need
	$moduleident = array();
	$modsettings = array();
	$modtitles = array(); // For threadid settings
	foreach ($modulecache AS $modid => $module)
	{
		if ($module['identifier'])
		{
			$moduleident['adv_portal_' . $module['identifier']] = $module['modid'];
		}
	}

	$excludegroups = '';
	if (!empty($moduleident))
	{
		$excludegroups = "AND grouptitle NOT IN('" . implode("', '", array_keys($moduleident)) . "')";
	}

	$groups = $db->query_read("
		SELECT grouptitle
		FROM " . TABLE_PREFIX . "adv_settinggroup
		WHERE (grouptitle LIKE 'adv_portal%' OR grouptitle = 'adv_global')
			$excludegroups
		ORDER BY displayorder
	");
	while ($group = $db->fetch_array($groups))
	{
		$grouptitles[$optionlabel][$group['grouptitle']] = $settingphrase['settinggroup_' . $group['grouptitle']];
		$grouptitlecache[] = $group['grouptitle'];
	}

	// ##### Module settings
	if (!empty($moduleident))
	{
		$gettitles = $db->query_read("
			SELECT grouptitle
			FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle IN('" . implode("', '", array_keys($moduleident)) . "')
		");
		while ($titles = $db->fetch_array($gettitles))
		{
			if ($moduleident[$titles['grouptitle']])
			{
				$modsettings[] = $moduleident[$titles['grouptitle']];
			}
		}

		// Just query them here to easily order by title
		if (!empty($modsettings))
		{
			$modulelabel = construct_phrase($vbphrase['x_options'], $vbphrase['module']);

			$modsettings = array_unique($modsettings);

			$modules = $db->query_read("
				SELECT title, identifier
				FROM " . TABLE_PREFIX . "adv_modules AS module
				WHERE modid IN(" . implode(',', $modsettings) . ")
				ORDER BY title
			");
			while ($module = $db->fetch_array($modules))
			{
				$gtitle = 'adv_portal_' . $module['identifier'];
				$grouptitles[$modulelabel][$gtitle] = $module['title'];
				$settingphrase['settinggroup_' . $gtitle] = construct_phrase($vbphrase['x_options'], $module['title']);
				$grouptitlecache[] = $gtitle;
				$modulegroups[] = $gtitle;
				$modtitles['adv_portal_' . $module['identifier']] = $module['title'];
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_modify_settings')) ? eval($hook) : false;

	// Print it out
	print_form_header('vba_cmps_admin', 'modifysettings', false, true, 'cpform', '90%', '', true, 'get');
	if ($grouptitle)
	{
		print_table_header($vbphrase['setting_group'] . ' <select name="grouptitle" onchange="this.form.submit();" class="bginput" style="width:350px" tabindex="30">' .
			construct_select_options($grouptitles, $grouptitle) . '</select> <input type="submit" class="button" value="' . $vbphrase['go'] . '" />'
		);
		print_table_footer();
	}
	else
	{
		print_table_header(construct_phrase($vbphrase['x_options'], $vbphrase['vbadvanced_cmps']));
		print_label_row($vbphrase['settings_to_edit'], '<select name="grouptitle" ondblclick="this.form.submit();" class="bginput" style="width:350px" size="' . min(20, (sizeof($grouptitlecache) + 3)) . '" tabindex="1">' .
			construct_select_options($grouptitles, 'all') . '</select>'
		);
		print_submit_row($vbphrase['edit_settings'], '');
	}

	if ($grouptitle)
	{
		$fetchgroups = array();
		// Get options for specific group, or all
		if ($grouptitle == 'all')
		{
			$fetchgroups =& $grouptitlecache;
		}
		else
		{
			$fetchgroups = array($grouptitle);
		}

		print_form_header('vba_cmps_admin', 'saveopts');
		print_adv_setting_group('main', $fetchgroups);
		print_submit_row();
	}
}

// ##### Save Settings ########################################################
if ($_POST['do'] == 'saveopts')
{
	$setting = $_POST['setting'];

	construct_cmps_settings();

	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings', 0);
}

// ##### Add / Edit Setting ###################################################
if ($_REQUEST['do'] == 'addsetting' OR $_REQUEST['do'] == 'editsetting')
{
	$varname = $_REQUEST['varname'];
	$identifier = 'adv_portal_' . htmlspecialchars($_REQUEST['identifier']);

	print_form_header('vba_cmps_admin', 'do' . $_REQUEST['do']);
	print_table_header(
		iif($_REQUEST['do'] == 'editsetting',
			$vbphrase['edit_setting'] . ': ' . $varname,
			$vbphrase['add_setting']
		)
	);
	construct_hidden_code('modid', $_REQUEST['modid']);

	// Edit setting
	if ($_REQUEST['do'] == 'editsetting')
	{
		$setting = $db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "adv_setting
			WHERE varname = '" . $db->escape_string($varname) . "'
				AND grouptitle = '" . $db->escape_string($identifier) . "'
		");

		construct_hidden_code('setting[varname]', $setting['varname']);
		print_label_row($vbphrase['varname'], '<strong>' . $setting['varname'] . '</strong>');
		$identifier = $setting['grouptitle'];

		$phrases = $db->query_read("
			SELECT varname, text
			FROM " . TABLE_PREFIX . "phrase
			WHERE varname IN ('setting_$setting[varname]_title', 'setting_$setting[varname]_desc')
				AND fieldname = 'vbsettings'
		");
		while ($phrase = $db->fetch_array($phrases))
		{
			if ($phrase['varname'] == 'setting_' . $setting['varname'] . '_title')
			{
				$setting['title'] = $phrase['text'];
			}
			else
			{
				$setting['description'] = $phrase['text'];
			}
		}
	}
	// Add setting
	else
	{
		$maxorder = $db->query_first("SELECT MAX(displayorder) AS max FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = '$identifier'");
		$setting['displayorder'] = $maxorder['max'] + 10;

		print_input_row($vbphrase['varname'], 'setting[varname]', $setting['varname']);
	}
	print_input_row($vbphrase['title'], 'setting[title]', $setting['title']);
	construct_hidden_code('setting[identifier]', $identifier);
	print_textarea_row($vbphrase['description'], 'setting[description]', $setting['description']);
	print_textarea_row($vbphrase['option_code'], 'setting[optioncode]', $setting['optioncode'], 4, 50);
	print_textarea_row($vbphrase['default'], 'setting[defaultvalue]', $setting['defaultvalue'], 4, 50);
	print_input_row($vbphrase['display_order'], 'setting[displayorder]', $setting['displayorder']);
	print_yes_no_row($vbphrase['serialize'], 'setting[serialize]', $setting['serialize']);
	print_submit_row();
}

// ##### Do Add Setting #######################################################
if ($_POST['do'] == 'doaddsetting')
{
	$setting = $_POST['setting'];
	$modid = intval($_POST['modid']);

	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product)
		VALUES (
			0,
			'setting_" . $setting['varname'] . "_title',
			'" . $db->escape_string(htmlspecialchars($setting['title'])) ."',
			'vbsettings',
			'adv_cmps'
	)");
	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product)
		VALUES (
			0,
			'setting_" . $setting['varname'] . "_desc',
			'" . $db->escape_string($setting['description']) . "',
			'vbsettings',
			'adv_cmps'
	)");

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder)
		VALUES (
			'$setting[varname]',
			'$setting[identifier]',
			'$setting[defaultvalue]',
			'$setting[defaultvalue]',
			'" . $db->escape_string($setting['optioncode']) . "',
			'$setting[displayorder]'
	)");

	build_adv_settings();

	print_cp_redirect(
		'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . iif($modid,
			'editmodule&modid=' . $modid,
			'modifysettings'
		),
	0);

}

// ##### Do Edit Setting ######################################################
if ($_POST['do'] == 'doeditsetting')
{
	$setting = $_POST['setting'];
	$modid = intval($_POST['modid']);

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			defaultvalue = '$setting[defaultvalue]',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = '$setting[displayorder]',
			serialize = $setting[serialize]
		WHERE varname = '$setting[varname]' AND grouptitle = '$setting[identifier]'
	");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($setting['description']) . "'
		WHERE varname = 'setting_" . $setting['varname'] . "_desc'
			AND fieldname = 'vbsettings'
	");

	$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET
		text = '" . $db->escape_string($setting['title']) . "'
	WHERE varname = 'setting_" . $setting['varname'] . "_title'
		AND fieldname = 'vbsettings'
	");

	build_adv_settings();

	if ($modid)
	{
		print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&modid=' . $modid . '#settings', 0);
	}
	else
	{
		print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings&grouptitle=' . $setting['identifier'], 0);
	}
}

// ##### Remove Setting #######################################################
if ($_REQUEST['do'] == 'removesetting')
{
	$varname = htmlspecialchars($_REQUEST['varname']);
	$grouptitle = htmlspecialchars($_REQUEST['grouptitle']);
	$identifier = htmlspecialchars($_REQUEST['identifier']);

	if ($identifier)
	{
		$grouptitle = 'adv_portal_' . $identifier;
	}

	$settingphrase = $db->query_first("
		SELECT text
		FROM " . TABLE_PREFIX . "phrase
		WHERE varname = 'setting_" . $db->escape_string($varname) . "_title'
		ORDER BY languageid ASC
	");

	print_form_header('vba_cmps_admin', 'doremovesetting');
	construct_hidden_code('varname', $varname);
	construct_hidden_code('grouptitle', $grouptitle);
	construct_hidden_code('modid', intval($_REQUEST['modid']));
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row(construct_phrase($vbphrase['are_you_sure_want_to_delete_setting_x'], $settingphrase['text']) . '<div class="smallfont">(' . $varname . ')</div>');
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Remove Setting ####################################################
if ($_POST['do'] == 'doremovesetting')
{
	$varname = htmlspecialchars($_POST['varname']);
	$grouptitle = htmlspecialchars($_POST['grouptitle']);
	$modid = intval($_POST['modid']);

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	$dupecheck = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
	if (!$dupecheck['varname'])
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_desc'");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_title'");
	}

	build_adv_settings();

	if ($modid)
	{
		print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&modid=' . $modid . '#settings', 0);
	}
	else
	{
		print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings', 0);
	}
}

// ##### List Modules #########################################################
if ($_REQUEST['do'] == 'listmodules')
{
	?>
	<script type="text/javascript">
	function js_mod_jump(modid)
	{
		action = eval("document.cpform.m" + modid + ".options[document.cpform.m" + modid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				paction = 'editmodule';
			break;
			case 'copy':
				paction = 'copymodule';
			break;
			case 'remove':
				paction = 'removemodule';
			break;
			case 'modulepages':
				paction = 'modulepages';
			break;
		}
		document.cpform.reset();

		window.location = "vba_cmps_admin.php?do=" + paction + "&modid=" + modid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
	}
	</script>

	<?php

	$modoptions = array(
		'edit' => $vbphrase['edit_module'],
		'copy' => $vbphrase['copy_module'],
		'remove' => $vbphrase['remove_module'],
		'modulepages' => $vbphrase['add_remove_from_pages']
	);

	// Get a list of active pages for each module
	$activepage = array();
	$getpages = $db->query_read("
		SELECT pageid, title, modules
		FROM " . TABLE_PREFIX . "adv_pages
		ORDER BY displayorder
	");
	while ($pages = $db->fetch_array($getpages))
	{
		$pages['modules'] = unserialize($pages['modules']);

		if (!empty($pages['modules']))
		{
			foreach ($pages['modules'] AS $colid => $colmods)
			{
				if (!empty($colmods))
				{
					foreach ($colmods AS $amodid => $modorder)
					{
						$activepages[$amodid][] = $pages['title'];
					}
				}
			}
		}
	}

	// style keeps FF from printing the 'Add remove from pages' link too close to the table
	print_form_header('vba_cmps_admin', 'listmodules', false, true, 'cpform" style="margin: 0; padding-bottom: 15px;');

	$pagedata = fetch_page_data('adv_modules');

	print_table_header('<span style="float:' . $stylevar['right'] . '">' .
		construct_phrase(
			$vbphrase['showing_w_x_to_y_of_z'],
			$vbphrase['modules'],
			$pagedata['minlimit'],
			$pagedata['maxlimit'],
			$pagedata['count']
		) . '</span>' .
		$vbphrase['edit_modules'],
		5
	);
	echo '<tr>
		<td class="thead" width="45%">' . $vbphrase['title'] . '</td>
		<td class="thead" width="20%" align="center">' . $vbphrase['controls'] . '</td>
		<td class="thead" width="10%" style="white-space: nowrap">' . $vbphrase['module_type'] . '</td>
		<td class="thead" width="25%" align="' . $stylevar['right'] . '">' . $vbphrase['pages_active_on'] . '</td>
	</tr>';

	$modules = array();
	$getmods = $db->query_read("
		SELECT modid, title, inctype, active
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE inctype != 'custom'
		ORDER BY title, modid
		LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
	");
	while ($mods = $db->fetch_array($getmods))
	{
		$activesel = '<div align="' . $stylevar['right'] . '">';

		$pagecount = sizeof($activepages[$mods['modid']]);

		if (!$pagecount)
		{
			$activesel .= $vbphrase['none'];
		}
		else
		{
			$activesel .= '<select name="active' . $mods['modid'] . '" style="width:155px" class="bginput" tabindex="1005">';

			if (sizeof($activepages[$mods['modid']]) > 1)
			{
				$activesel .= '<option value="0">' . $pagecount . ' ' . $vbphrase['pages'] . '</option>
				<option value="0">--------</option>';
				foreach ($activepages[$mods['modid']] AS $actpage)
				{
					$activesel .= '<option value="0">' . $actpage . '</option>';
				}
			}
			else
			{
				$activesel .= '<option value="0">' . $activepages[$mods['modid']][0] . '</option>';
			}

			$activesel .= '</select>';
		}

		$activesel .= '</div>';

		$inactive = '';
		if (!$mods['active'])
		{
			$mods['title'] = '<strike>' . $mods['title'] . '</strike>';
			$inactive = ' (' . $vbphrase['inactive'] . ')';
		}

		print_cells_row(
			array(
				construct_link_code(
					$mods['title'],
					'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&amp;modid=' . $mods['modid']
				) . $inactive,
				'<div style="white-space: nowrap"><select name="m' . $mods['modid'] . '" onchange="js_mod_jump(' . $mods['modid'] . ');" class="bginput" tabindex="1">' . construct_select_options($modoptions) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_jump(' . $mods['modid'] . ');" tabindex="1" /></div>',
				$vbphrase[$mods['inctype']],
				$activesel
			)
		);
	}

	// Page navigation
	if ($pagedata['pagecount'] > 1)
	{
		if ($pagedata['pagenumber'] < $pagedata['pagecount'])
		{
			construct_hidden_code('page', $pagedata['pagenumber'] + 1);
			print_submit_row($vbphrase['next_page'], '', 5, iif($pagedata['pagenumber'] != 1, $vbphrase['last_page']), '', true);
		}
		else
		{
			construct_hidden_code('page', 1);
			print_submit_row($vbphrase['first_page'], '', 5, $vbphrase['last_page'], '', true);
		}
	}
	else
	{
		print_table_footer();
	}

	echo '<div align="center" style="font-weight: bold;">' . construct_link_code(
			$vbphrase['add_remove_modules_from_pages'],
			'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listpages'
		) . '</div>';
}

// ##### Mass Add Module to Pages #############################################
if ($_REQUEST['do'] == 'modulepages')
{
	$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);

	if (!$modid)
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	$pagecache = cache_cmps_pages();

	$modulecache = cache_cmps_modules();
	$colphrase = fetch_column_phrases(array_values($vba_options['portal_column_array']));

	print_table_start();
	print_table_header($vbphrase['add_remove_from_pages'] . ': ' . $modulecache[$modid]['title']);
	print_table_footer();

	print_form_header('vba_cmps_admin', 'domodulepages');

	$moveselect = '<select name="modpos[' . $pmodid . '][col]" class="bginput" tabindex="1">
		<option value="' . $modcol . '">' . $vbphrase['move_to'] . '</option>
		<option value="' . $modcol . '">----------</option>
	';

	$movechoice = array();
	foreach ($vba_modcols AS $colid => $coltitle)
	{
		$movechoice[$colid] = $colphrase[$coltitle . '_column'];
	}

	$modcolsize = sizeof($vba_modcols);

	if (!empty($pagecache))
	{
		foreach ($pagecache AS $pageid => $vba_page)
		{
			$selectedcol = 0;
			$orderval = '';

			$vba_page['modules'] = unserialize($vba_page['modules']);

	$actmodbits = '';
	$activemods = array();
	if (!empty($vba_page['modules']))
	{
		$colcount = 0;
		$actmodbits = '<tr>';
		foreach ($vba_modcols AS $vba_col => $col_phrase)
		{
			$colcount++;
			$actmodbits .= '<td width="' . round(100 / $modcolsize) . '%" class="" valign="top">
				<table width="100%" cellspacing="0" cellpadding="4" class="tborder">
					<tr>
						<td class="tfoot" colspan="2"><strong>' . $colphrase[$col_phrase . '_column'] . '</strong></td>
					</tr>';


			// See if the column has mods like this since we could have a deleted module in the layout
			$colhasmods = false;
			if (!empty($vba_page['modules'][$vba_col]))
			{
				$actmodbits .= '
						<tr>
							<td class="thead">' . $vbphrase['title'] . '</td>
							<td class="thead">' . $vbphrase['order'] . '</td>
						</tr>';

				if (in_array($modid, array_keys($vba_page['modules'][$vba_col])))
				{
					$selectedcol = $vba_col;
					$orderval = $vba_page['modules'][$vba_col][$modid];
				}

				foreach ($vba_page['modules'][$vba_col] AS $pmodid => $modorder)
				{
					$pmod =& $modulecache[$pmodid];
					$activemods[] = $pmodid;

					// Nothing in the cache, so it must be a deleted module
					if (empty($pmod))
					{
						continue;
					}

					$colhasmods = true;

					$moveselect = '<select name="pagemodpos[' . $pageid . '][' . $pmodid . '][col]" class="bginput" tabindex="1">
						<option value="' . $vba_col . '">' . $vbphrase['move_to'] . ':</option>
						<optgroup label="----------"></optgroup>
					';

					foreach ($vba_modcols AS $colid => $coltitle)
					{
						$moveselect .= '<option value="' . $colid . '">' . $colphrase[$coltitle . '_column'] . '</option>';
					}

					$moveselect .= '</select>';

					exec_switch_bg();

					$actmodbits .= '<tr>
						<td class="' . $bgclass . '" colspan="2">
							<strong>' . $pmod['title'] . '</strong>' . $pmod['inactive'] . '
						</td>
						</tr>
						<tr>
						<td class="' . $bgclass . '">
							<div>' . $moveselect . '</div>
							<div class="smallfont"><input type="checkbox" id="remove_' . $pageid . '_' . $pmodid . '" name="removepagemods[' . $pageid . '][]" value="' . $pmodid . '" /><label for="remove_' . $pageid . '_' . $pmodid . '">' . $vbphrase['remove'] . '</label></div>
						</td>
						<td class="' . $bgclass . '" valign="top"><input type="text" name="pagemodpos[' . $pageid . '][' . $pmodid . '][order]" size="3" class="bginput" value="' . $modorder . '" /></td>
					</tr>';
				}
			}

			if (!$colhasmods)
			{
				$actmodbits .= '<tr><td class="alt1">' . $vbphrase['no_modules'] . '</td></tr>';
			}

			$actmodbits .= '</table></td>';


			if ($colcount == 3)
			{
				$colcount = 0;
				$actmodbits .= '</tr><tr>';
			}
		}

		while ($colcount < 3)
		{
			$colcount++;
			$actmodbits .= '</td><td>';
		}
		$actmodbits .= '</tr><tr>';
	}

			// ##### Print out the table for each module
			print_description_row(str_repeat('--', ($vba_page['level'] - 1)) . $vba_page['title'], false, 2, 'thead');

			if ($selectedcol)
			{
				print_description_row('(' . $vbphrase['active'] . ') - ' .
					$colphrase[$vba_modcols[$selectedcol] . '_column'] . ' - ' . $vbphrase['order'] . ': ' . $orderval .
					'<br /><input type="checkbox" id="remove_' . $pageid . '_' . $modid . '_sel" name="removepagemods[' . $pageid . '][]" value="' . $modid . '" /><label for="remove_' . $pageid . '_' . $modid . '_sel">' . $vbphrase['remove'] . '</label></div>');
			}
			else
			{
				print_description_row('(' . $vbphrase['inactive'] . ')<div>' .
					$vbphrase['move_to'] .
					': <select name="pagemodpos[' . $pageid . '][' . $modid . '][col]" class="bginput" tabindex="1">' .
						construct_select_options(array(0 => $vbphrase['none'], '-----------' => $movechoice), $selectedcol) .
					'</select>&nbsp;&nbsp;&nbsp;' . $vbphrase['order'] . ': <input type="text" class="bginput" size="3" name="pagemodpos[' . $pageid . '][' . $modid . '][order]" value="' . $orderval . '" /></div>'
				);
			}

			echo '</table><table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder" style="border-top: 0">';

			// Expand other modules
			echo '<thead>';
			print_description_row(
				'<a href="#top" onclick="return toggle_collapse(\'vbapage_' . $pageid . '\')"><img alt="" border="0" id="collapseimg_vbapage_' . $pageid . '" src="../images/misc/vba_cp_collapsed.gif" /></a> ' . $vbphrase['view_edit_active_modules_on_this_page'],
				false, $modcolsize, 'tfoot'
			);
			echo '</thead><tbody id="collapseobj_vbapage_' . $pageid . '" style="display: none">';

			echo '<tr><td>' . $actmodbits . '</td></tr>';

			echo '</tbody>';

			print_table_break();
		}
	}

	print_submit_row();
}

// ##### Mass update page modules #############################################
if ($_POST['do'] == 'domodulepages')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'pagemodpos' => TYPE_ARRAY,
		'removepagemods' => TYPE_ARRAY
	));

	// Cache the pages so we can compare the serialized array and only update if needed
	$pagecache = cache_cmps_pages();

	if (!empty($vbulletin->GPC['pagemodpos']))
	{
		foreach ($vbulletin->GPC['pagemodpos'] AS $pageid => $pagemods)
		{
			$layout = serialize(format_module_layout(
				$pagemods,
				iif(is_array($vbulletin->GPC['removepagemods'][$pageid]),
					$vbulletin->GPC['removepagemods'][$pageid],
					array()
				)
			));

			if ($layout != $pagecache[$pageid]['modules'])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_pages SET
						modules = '" . $db->escape_string($layout) . "'
					WHERE pageid = $pageid
				");

				// Update the homepage cache
				if ($pagecache[$pageid]['name'] == 'home')
				{
					update_homepage_cache();
				}
			}
		}
	}

	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listmodules', 0);
}

// ##### Copy Module Layout ###################################################
if ($_REQUEST['do'] == 'copylayout')
{
	print_form_header('vba_cmps_admin', 'docopylayout');
	print_table_header($vbphrase['copy_module_layout_from_another_page']);
	print_description_row($vbphrase['tool_allows_copy_layouts']);

	print_table_break();

	$pagesel = fetch_page_select_array($vbphrase['please_select_a_page']);

	$copytobits = '';
	foreach ($pagecache AS $pageid => $vba_page)
	{
		$copytobits .= '<div style="padding: 2px"><input type="checkbox" id="copyto_' . $pageid . '" name="copyto[]" value="' . $pageid . '" /> <label for="copyto_' . $pageid . '">' . str_repeat('--', ($vba_page['level'] - 1)) . ' ' . $vba_page['title'] . '</label></div>';
	}

	print_description_row($vbphrase['copy_module_layout'], false, 2, 'thead');
	print_select_row($vbphrase['page_to_copy_from'], 'copypage', array(0 => $vbphrase['please_select_one'], '----------' => $pagesel));
	print_label_row(
		$vbphrase['pages_to_copy_to'] . '<div style="padding-top:8px"><input name="checkall_pages" value="1" onclick="check_all_array(this, \'copyto\');" type="checkbox" id="checkall_pages" /><label for="checkall_pages">' . $vbphrase['check_all'] . '</label></div>',
		$copytobits
	);
	print_submit_row($vbphrase['copy']);
}

// ##### Do Copy Module Layout ################################################
if ($_POST['do'] == 'docopylayout')
{
	$copypage = $vbulletin->input->clean_gpc('p', 'copypage', TYPE_INT);
	$copyto = $vbulletin->input->clean_gpc('p', 'copyto', TYPE_ARRAY_INT);

	$pageinfo = $db->query_first("
		SELECT pageid, modules
		FROM " . TABLE_PREFIX . "adv_pages
		WHERE pageid = $copypage
	");

	if (!$pageinfo['pageid'])
	{
		print_stop_message('invalid_page_specified');
	}

	if (!empty($copyto))
	{
		foreach ($copyto AS $pageid)
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_pages SET
					modules = '" . $db->escape_string($pageinfo['modules']) . "'
				WHERE pageid = $pageid
			");
		}
	}

	print_stop_message('adv_portal_layouts_copied_successfully');

}

// ##### New Module ###########################################################
if ($_REQUEST['do'] == 'newmodule' OR $_REQUEST['do'] == 'newpage')
{
	if ($_REQUEST['do'] == 'newmodule')
	{
		$typephrase = $vbphrase['x_module'];
		$type = 'module';
	}
	else
	{
		$typephrase = $vbphrase['x_page'];
		$type = 'page';
	}

	$allowphrase = $vbphrase[$type];
	$allowphrase_lwr = strtolower($allowphrase);

	$pageid = $vbulletin->input->clean_gpc('r', 'pageid', TYPE_INT);

	print_form_header('', '');

	print_table_header($vbphrase[$type . '_type']);

	print_description_row(construct_phrase($vbphrase['please_select_type_of_x_to_add'], $vbphrase[$type]), '', 2, 'thead');

	$urlstart = 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=add' . $type . iif($pageid, '&amp;parentpage=' . $pageid) . '&amp;type=';

	// Moudle page
	if ($type == 'page')
	{
		print_label_row(
			construct_link_code(
				construct_phrase($typephrase, $vbphrase['module']),
				$urlstart . 'module'),
			$vbphrase['module_allows_module']
		);
	}

	// BB code
	print_label_row(
		construct_link_code(
			construct_phrase($typephrase, $vbphrase['bb_code']),
			$urlstart . 'bb_code'
		),
		construct_phrase($vbphrase['bbcode_allows_bbcode'], $allowphrase, $allowphrase_lwr)
	);

	// Template
	print_label_row(
		'<div style="white-space: nowrap">' . construct_link_code(
			construct_phrase($typephrase, $vbphrase['template']),
			$urlstart . 'template'
		) . '</div>',
		construct_phrase($vbphrase['template_allows_template'], $allowphrase, $allowphrase_lwr)
	);

	// PHP File
	print_label_row(
		construct_link_code(
			construct_phrase($typephrase, $vbphrase['php_file']),
			$urlstart . 'php_file'
		),
		construct_phrase(
			$vbphrase['file_allows_file'],
			$allowphrase,
			$allowphrase_lwr,
			iif($type == 'page',
				$vbphrase['from_anywhere_on_your_server'],
				$vbphrase['from_modules_directory']
			)
		)
	);

	// HTML Page
	if ($type == 'page')
	{
		$bgclass = exec_switch_bg();
		echo '<tr valign="top">
			<td class="' . $bgclass . '" nowrap="nowrap">' . construct_link_code(construct_phrase($typephrase, $vbphrase['html_file']), $urlstart . 'html_file') . '</td>
			<td class="' . $bgclass . '">' . $vbphrase['html_allows_html'] . '</td>
		</tr>';
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_new_page_or_module')) ? eval($hook) : false;


	print_table_footer();
}

// ##### Add / Edit Module ####################################################
if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
{

	if ($_REQUEST['do'] == 'addmodule' AND !$_REQUEST['type'])
	{
		print_stop_message('adv_portal_must_choose_x_type', $vbphrase['module']);
	}

	?>
	<script type="text/javascript">

	var message_popped = false;

	function wrapper_enabled()
	{
		if (!message_popped)
		{
			if (document.vbform.elements["module[useshell][enable]"][1].checked)
			{
				message_popped = true;

				if (confirm('<?php echo addslashes($vbphrase['use_module_wrapper_must_be_enabled']); ?>'))
				{
					document.vbform.elements["module[useshell][enable]"][0].checked = true;
				}
			}
		}
		return true;
	}

	function js_mod_tools(tool)
	{
		action = eval("document.vbform.tool_" + tool + ".options[document.vbform.tool_" + tool + ".selectedIndex].value");
		switch (action)
		{
			case 'copymodule':
			case 'removemodule':
			case 'modulepages':
				page = action;
			break;
			case 'chtype_template':
				page = 'editmodule&chtype=template';
			break;
			case 'chtype_php_file':
				page = 'editmodule&chtype=php_file';
			break;
			case 'chtype_bb_code':
				page = 'editmodule&chtype=bb_code';
			break;

		}
		document.vbform.reset();

		window.location = "vba_cmps_admin.php?do=" + page + "&modid=<?php echo intval($_REQUEST['modid']) . '&s=' . $vbulletin->session->vars['sessionhash']; ?>";
	}

	function js_template_edit(tempname)
	{
		thisstyleid = eval("document.vbform.edittemp.options[document.vbform.edittemp.selectedIndex].value");
		document.vbform.reset();

		window.location = "vba_cmps_admin.php?do=edittemp&thisstyleid=" + thisstyleid + "&tempname=" + tempname +"&s=<?php echo $vbulletin->session->vars['sessionurl']; ?>";
	}

	</script>


	<?php

	$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);
	$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_NOHTML);
	$chtype = $vbulletin->input->clean_gpc('r', 'chtype', TYPE_NOHTML);

	require_once(DIR . '/includes/adminfunctions_template.php');

	// Edit / Copy module
	if ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule')
	{
		if ($_REQUEST['do'] == 'copymodule')
		{
			$headertitle = $vbphrase['copy_module'] . ': ' . $module['title'];
		}
		else
		{
			$headertitle = $vbphrase['edit_module'] . ': <span class="normal">' . $module['title'] . ' (modid: ' . $modid . ')</span>';
		}

		if (!$module['modid'])
		{
			print_stop_message('invalid_x_specified', $vbphrase['module']);
		}

		if ($chtype)
		{
			$module['filename'] = '';
			$type = $chtype;
		}
		else
		{
			$type = $module['inctype'];
		}

		$shellopts = convert_bits_to_array($module['useshell'], $vba_shellint);
	}
	// Add module
	else
	{
		$headertitle = $vbphrase['add_module'] . ': <span class="normal">' . $vbphrase[$type] . ' ' . $vbphrase['module'] . '</span>';
		$module['active'] = 1;
		$shellopts = array('enable' => 1);
	}

	$modtypes = array(
		'noaction' => $vbphrase['please_select_one'],
		'chtype_php_file' => $vbphrase['php_file'],
		'chtype_template' => $vbphrase['template'],
		'chtype_bb_code' => $vbphrase['bb_code']
	);

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_module_start')) ? eval($hook) : false;

	// Main options
	echo '<form action="vba_cmps_admin.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(0, 0)"') . '>
		<input type="hidden" name="do" value="do' . iif($_REQUEST['do'] == 'editmodule', 'editmodule', 'addmodule') . '" />
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	if ($vbulletin->session->vars['sessionhash'])
	{
		echo '<input type="hidden" name="s" value="' . htmlspecialchars($vbulletin->session->vars['sessionhash']) . '" />';
	}

	print_table_start();

	print_table_header($headertitle);

	// Copy module
	if ($_REQUEST['do'] == 'copymodule')
	{
		print_description_row(construct_phrase(
				$vbphrase['copying_x_note'],
				strtolower($vbphrase['module']),
				$module['title']
		));
	}
	// Edit module
	else if ($_REQUEST['do'] == 'editmodule')
	{
		// No options for the custom page content module
		// (this shouldn't be accessible anymore, but just incase)
		if ($module['identifier'] == 'custompage')
		{
			print_description_row($vbphrase['custom_page_content_description']);
			print_cp_footer();
			exit;
		}
		else if ($chtype)
		{
			// Change module type note
			print_description_row(
				construct_phrase($vbphrase['change_x_type'], $vbphrase['module']),
				0, 2, 'thead'
			);
			print_description_row(construct_phrase(
					$vbphrase['change_x_type_note'],
					$vbphrase['module'],
					$vbphrase[$module['inctype']],
					$vbphrase[$type]
			));
		}
		else
		{
			// Module tools
			print_description_row(construct_phrase($vbphrase['x_tools'], $vbphrase['module']), 0, 2, 'thead');
			print_label_row(
				$vbphrase['select_an_action'],
				'<select name="tool_def" onchange="js_mod_tools(\'def\');" class="bginput">' .
					construct_select_options(array(
						'noaction' => $vbphrase['please_select_one'],
						'copymodule' => $vbphrase['copy_module'],
						'removemodule' => $vbphrase['remove_module'],
						'modulepages' => $vbphrase['add_remove_from_pages']
					)) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_tools(\'def\');" />',
				'', 'top', '', true
			);

			unset($modtypes['chtype_' . $type]);

			print_label_row(construct_phrase($vbphrase['change_x_type'], $vbphrase['module']),
				'<select name="tool_chtype" onchange="js_mod_tools(\'chtype\');" class="bginput">' .
					construct_select_options($modtypes) .
				'</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_mod_tools(\'chtype\');" />'
			);

			// Template options
			if ($type == 'template')
			{
				cache_styles();

				$styles = array();
				foreach ($stylecache AS $sid => $sinfo)
				{
					$styles[$sid] = $sinfo['title'];
				}
				print_label_row(
					construct_phrase($vbphrase['edit_template_for_x_in_style'], $vbphrase['module']),
					'<select name="edittemp" onchange="js_template_edit(\'' . $module['filename'] . '\');" class="bginput">' .
						construct_select_options($styles) . '
					</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_template_edit(\'' . $module['filename'] . '\');" />'
				);
			}
		}
	}

	if ($_REQUEST['do'] != 'addmodule')
	{
		print_table_break();
	}

	print_table_break();
	print_table_break();

	// ##### Main options
	print_table_header($vbphrase['main_options']);
	construct_hidden_code('modid', $module['modid']);
	construct_hidden_code('module[inctype]', $type);

	print_input_row($vbphrase['module_title'], 'module[title]', $module['title']);
	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', $module['active']);

	if ($type == 'bb_code' OR $type == 'php_file')
	{
		$modopts = convert_bits_to_array($module['options'], ($type == 'php_file' ? $vba_php_modint : $vba_bbc_modint));
	}

	if ($type == 'custom')
	{
		construct_hidden_code('module[identifier]', 'custompage');
	}
	else
	{
		print_description_row(construct_phrase($vbphrase['x_y_options'], $vbphrase['module'], $vbphrase[$type]), false, 2, 'thead');

		switch ($type)
		{
			// ##### PHP File module
			case 'php_file':
				$filenames = array();

				$directory = opendir('./modules');
				while ($modfile = readdir($directory))
				{
					if (ereg('[^.]+', $modfile) AND $modfile != 'index.html')
					{
						$filenames[$modfile] = $modfile;
					}
				}

				closedir($directory);
				asort($filenames);

				$filearray = array(0 => $vbphrase['choose_a_file'], '---------------' => $filenames);

				print_select_row($vbphrase['file_to_include'], 'module[filename]', $filearray, $module['filename']);

				$modselcache = array();
				$modselcache[''] = $vbphrase['none'];
				$getmodules = $db->query_read("
					SELECT identifier, title
					FROM " . TABLE_PREFIX . "adv_modules
					WHERE identifier != ''
					ORDER BY title, modid
				");
				while ($modules = $db->fetch_array($getmodules))
				{
					$modselcache[$modules['identifier']] = $modules['title'];
				}

				$db->free_result($getmodules);
				unset($modules);

				print_select_row($vbphrase['module_parent'], 'module[parent]', $modselcache, $module['parent']);

				// Identifier for adding/copying
				if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'copymodule')
				{
					if ($_REQUEST['do'] == 'copymodule')
					{
						$modidents = array();
						$modids = $db->query_read("
							SELECT identifier
							FROM " . TABLE_PREFIX . "adv_modules
							WHERE identifier LIKE '" . $db->escape_string($module['identifier']) . "%'
						");
						while ($modident = $db->fetch_array($modids))
						{
							$modidents[] = $modident['identifier'];
						}

						$idcount = 1;
						$foundident = false;
						$oldident = $module['identifier'];
						construct_hidden_code('oldident', $oldident);
						while (!$foundident)
						{
							$idcount++;
							if (!in_array($module['identifier'] . $idcount, $modidents))
							{
								$module['identifier'] = $module['identifier'] . $idcount;
								$foundident = true;
							}
						}
					}
					print_input_row($vbphrase['identifier'] . '<div class="smallfont">' . $vbphrase['identifier_desc'] . '</div>', 'module[identifier]', $module['identifier']);
				}
				else
				{
					construct_hidden_code('module[identifier]', $module['identifier']);
				}
				print_textarea_row($vbphrase['templates_used'], 'module[templatelist]', $module['templatelist'], 4, 40, 1, 0);
				print_yes_no_row($vbphrase['initialize_bbcode_parser'], 'module[options][load_bbcode_parser]', $modopts['load_bbcode_parser']);
				print_yes_no_row($vbphrase['initialize_forum_permissions'], 'module[options][load_forum_perms]', $modopts['load_forum_perms']);
				print_yes_no_row($vbphrase['initialize_moderator_cache'], 'module[options][load_moderators]', $modopts['load_moderators']);
				print_yes_no_row($vbphrase['initialize_ignored_users'], 'module[options][load_ignusers]', $modopts['load_ignusers']);

				print_yes_no_row($vbphrase['clean_file_output'], 'module[options][clean_output]', $modopts['clean_output']);

			break;

			// ##### Template module
			case 'template':

				echo '<tr><td class="alt2" width="100%">' . $vbphrase['template_to_include'] . '</td><td align="' . $stylevar['left'] . '" class="alt2"><span class="smallfont">adv_portal_</span><input type="text" class="bginput" name="module[filename]" id="it_module[filename]" value="' . $module['filename'] . '" size="24" tabindex="1" /></td></tr>';

				print_new_template_box();

			break;

			// ##### BB code module
			case 'bb_code':
				if ($_REQUEST['do'] == 'addmodule')
				{
					$modopts['allow_html'] = 1;
					$modopts['allow_smilies'] = 1;
					$modopts['allow_image_code'] = 1;
				}

				print_cp_text_editor('module');

			break;

			default:
				($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_module_switch_type')) ? eval($hook) : false;

		} // end switch ($type)

		print_middle_submit_row('', 2, 'module');
		print_table_break();
		print_table_break();

		// ##### Module shell options
		print_table_header($vbphrase['module_wrapper_template_options']);
		print_description_row($vbphrase['options_apply_to_module_wrapper'] . ' ' .
			iif($type != 'bb_code', $vbphrase['note_templates_should_use_format'] . '<div style="border: 1px inset; width:380px">&lt;tr&gt;<br />&lt;td class=&quot;$bgclass&quot;&gt; &lt;!-- Your code here --&gt; &lt;/td&gt;<br />&lt;/tr&gt;</div>'
			)
		, 0, 2, 'tfoot');
		print_yes_no_row(construct_phrase($vbphrase['use_module_wrapper_template'], $vbphrase['module']), 'module[useshell][enable]', $shellopts['enable']);
		print_input_row($vbphrase['alternative_module_wrapper_template'], 'module[altshell]', $module['altshell'], 1, 40, '', '', 'bginput" onchange="wrapper_enabled();');
		print_input_row(construct_phrase($vbphrase['x_link'], $vbphrase['module']), 'module[link]', $module['link'], 1, 40, '', '', 'bginput" onchange="wrapper_enabled();');
		print_input_row($vbphrase['title_row_colspan'], 'module[colspan]', $module['colspan'], 1, 40, '', '', 'bginput" onchange="wrapper_enabled();');
		print_textarea_row($vbphrase['form_code'], 'module[formcode]', $module['formcode'], 4, 40, true, true, $stylevar['left'] . '" onchange="wrapper_enabled();');
		print_yes_no_row($vbphrase['collapse_module_by_default'], 'module[useshell][collapse]', $shellopts['collapse'], 'wrapper_enabled();');

		print_middle_submit_row();
		print_table_break();
		print_table_break();

		// ##### Usergroup Permissions
		$module['userperms'] = explode(',', $module['userperms']);

		print_table_header($vbphrase['usergroup_permissions']);
		print_label_row(
			$vbphrase['here_specify_which_usergroups_view_module'],
			'<input name="checkall_userperms" value="1" onclick="check_all_array(this, \'userperms\');" type="checkbox" id="checkall_userperms" ' . iif(!array_diff(array_keys($vbulletin->usergroupcache), $module['userperms']), 'checked="checked" ') . '/> <label for="checkall_userperms">' . $vbphrase['all_yes'] . '</label>',
			'thead',
			'middle'
		);

		foreach ($vbulletin->usergroupcache AS $groupid => $usergroup)
		{
			print_checkbox_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', iif(in_array($usergroup['usergroupid'], $module['userperms']) OR $_REQUEST['do'] == 'addmodule', 1, 0));
		}

		print_middle_submit_row();
		print_table_break('<a name="settings"></a>');

		// ##### Module Settings
		if ($type == 'php_file' AND ($_REQUEST['do'] == 'editmodule' OR $_REQUEST['do'] == 'copymodule'))
		{
			if ($_REQUEST['do'] == 'copymodule')
			{
				$module['identifier'] = $oldident;
			}

			print_adv_setting_group('module', array(), iif($oldident, false, true));

			if (!empty($settingscache['adv_portal_' . $module['identifier']]))
			{
				$modulevars = array();
				foreach ($settingscache['adv_portal_' . $module['identifier']] AS $varname => $modsetting)
				{
					$modulevars[] = $varname;
				}
				$modulevars = implode(',', $modulevars);
			}

			construct_hidden_code('modulevars', $modulevars);

			print_table_break();
		}
	}

	if ($_REQUEST['do'] == 'editmodule' AND $type == 'php_file' AND $vbulletin->debug)
	{
		echo '<div align="center" style="margin-bottom:6px">' .
			construct_link_code(
				$vbphrase['add_setting'],
				'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=addsetting&amp;identifier=' . $module['identifier'] . '&amp;modid=' . $module['modid']
			) . '</div>';
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_module_end')) ? eval($hook) : false;


	print_submit_row();

}

// ##### Do Add / Edit Module #################################################
if ($_POST['do'] == 'doaddmodule' OR $_POST['do'] == 'doeditmodule')
{
	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$module = $vbulletin->input->clean_gpc('p', 'module', TYPE_ARRAY);
	$setting = $vbulletin->input->clean_gpc('p', 'setting', TYPE_ARRAY);
	$template = $vbulletin->input->clean_gpc('p', 'template', TYPE_STR);
	$userperms = $vbulletin->input->clean_gpc('p', 'userperms', TYPE_ARRAY);
	$thisstyleid = $vbulletin->input->clean_gpc('p', 'thisstyleid', TYPE_ARRAY_INT);
	$oldident = $vbulletin->input->clean_gpc('p', 'oldident', TYPE_STR);
	$message = $vbulletin->input->clean_gpc('p', 'message', TYPE_STR);
	$wysiwyg = $vbulletin->input->clean_gpc('p', 'wysiwyg', TYPE_STR);

	// Check Errors
	if (!$module['title'])
	{
		print_stop_message('adv_portal_must_choose_title_for_module');
	}

	if (!$module['filename'] AND $module['inctype'] != 'bb_code')
	{
		print_stop_message('adv_portal_must_choose_' . $module['inctype'] . '_include');
	}

	if ($module['inctype'] == 'php_file' AND $_REQUEST['do'] == 'doaddmodule')
	{
		if ($checkidentifier = $db->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = '" . $db->escape_string($module['identifier']) . "'"))
		{
			print_stop_message('adv_portal_duplicate_identifier', $vbphrase['module'], $module['identifier']);
		}
	}

	// Usergroup permissions
	$module['userperms'] = '';
	if (!empty($userperms))
	{
		$ugperms = array();
		foreach ($userperms AS $usergroupid => $allow)
		{
			if ($allow)
			{
				$ugperms[] = $usergroupid;
			}
		}
		$module['userperms'] = implode(',', $ugperms);
	}

	switch ($module['inctype'])
	{
		// ##### BB code
		case 'bb_code':

			$gettemp = $db->query_read("
				SELECT * FROM " . TABLE_PREFIX . "template
				WHERE title IN('bbcode_code', 'bbcode_html', 'bbcode_php', 'bbcode_quote')
					AND styleid = '-1'
			");
			while ($temp = $db->fetch_array($gettemp))
			{
				$vbulletin->templatecache[$temp['title']] = $temp['template'];
			}

			// Kill the wordwrap setting to avoid problems with HTML links/images
			$vbulletin->options['wordwrap'] = 0;

			include_once('./includes/class_bbcode.php');
			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

			$bbcode_parser->tag_list['no_option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);
			$bbcode_parser->tag_list['no_option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['no_option']['thread']['html']);

			$bbcode_parser->tag_list['option']['thread']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);
			$bbcode_parser->tag_list['option']['post']['html'] = str_replace('"showthread.php', '"' . $vbulletin->options['bburl'] . '/showthread.php', $bbcode_parser->tag_list['option']['thread']['html']);

			$module['filename'] = $vbulletin->GPC['message'];
			if ($vbulletin->GPC['wysiwyg'])
			{
				require_once(DIR . '/includes/functions_wysiwyg.php');
				$module['filename'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $setting['allowhtml']);
			}

			$module['code_parsed'] = $bbcode_parser->do_parse(
				$module['filename'],
				$module['options']['allow_html'],
				$module['options']['allow_smilies'],
				1,
				$module['options']['allow_image_code']
			);

		break;

		// ##### Template
		case 'template':

			insert_new_cmps_templates('adv_portal_' . $module['filename']);

		break;

		// ##### PHP File
		case 'php_file':

			$mod_grouptitle = 'adv_portal_' . $module['identifier'];
			// Duplicate the settings if copying
			if ($oldident)
			{
				$repsettings = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_$oldident'");
				while ($repsetting = $db->fetch_array($repsettings))
				{
					$repsetting['grouptitle'] = $mod_grouptitle;
					$db->query_write(fetch_query_sql($repsetting, 'adv_setting'));
				}

				// Switch the setting group for submitted settings with the new identifier
				$setting[$mod_grouptitle] = $setting['adv_portal_' . $oldident];
				unset($setting['adv_portal_' . $oldident]);
			}

			if (!empty($setting))
			{
				construct_cmps_settings('module');
			}

			// Make sure forum perms are loaded if a permissions option is enabled.
			if ($setting[$mod_grouptitle]['portal_applypermissions'])
			{
				$module['options']['load_forum_perms'] = 1;
			}

			// Sanitize Templates Used
			if ($module['templatelist'])
			{
				$module['templatelist'] = explode("\r\n", $module['templatelist']);

				if (!empty($module['templatelist']))
				{
					$module['templatelist'] = array_map('trim', $module['templatelist']);
				}

				if (!empty($module['templatelist']))
				{
					$module['templatelist'] = implode("\r\n", $module['templatelist']);
				}
			}
		break;
	}

	require_once(DIR . '/includes/functions_misc.php');

	// Module shell template
	$module['useshell'] = convert_array_to_bits($module['useshell'], $vba_shellint);

	// Options
	$newopts = 0;
	if ($module['inctype'] == 'php_file' OR $module['inctype'] == 'bb_code')
	{
		$newopts = convert_array_to_bits($module['options'], ($module['inctype'] == 'php_file' ? $vba_php_modint : $vba_bbc_modint));
	}
	$module['options'] = $newopts;

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_do_add_edit_module')) ? eval($hook) : false;

	if ($_POST['do'] == 'doaddmodule')
	{
		// Insert module
		$db->query_write(fetch_query_sql($module, 'adv_modules'));
		$modid = $db->insert_id();
	}
	else
	{
		// Update module
		$db->query_write(fetch_query_sql($module, 'adv_modules', 'WHERE modid = ' . $modid));
	}

	build_adv_settings();
	update_module_cache();

	if ($_POST['do'] == 'doaddmodule')
	{
		print_form_header('vba_cmps_admin', 'modulepages');
		construct_hidden_code('modid', $modid);
		print_table_header($vbphrase['vbulletin_message']);
		print_description_row(fetch_error('adv_portal_module_saved_add_to_pages', $vbulletin->session->vars['sessionurl']));

		print_submit_row($vbphrase['continue'], '', 2, '', construct_button_code($vbphrase['go_back'], 'vba_cmps_admin.php?do=newmodule'));
	}
	else
	{
		print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listmodules', 0);
	}

}

// ##### Remove Module ########################################################
if ($_REQUEST['do'] == 'removemodule')
{
	$modid = $vbulletin->input->clean_gpc('r', 'modid', TYPE_INT);

	$module = $db->query_first("
		SELECT modid, title, inctype, filename
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE modid = $modid
	");

	if (!$module['modid'])
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	print_form_header('vba_cmps_admin', 'doremovemodule');
	construct_hidden_code('modid', $modid);
	print_table_header($vbphrase['confirm_deletion']);

	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_module_called_x'], $module['title']));

	if (($module['inctype'] == 'php_file' OR $module['inctype'] == 'template') AND $module['filename'])
	{
		print_description_row('<input type="checkbox" name="removefile" value="1" id="removefile" /> <label for="removefile">' . construct_phrase(($module['inctype'] == 'php_file' ? $vbphrase['also_delete_module_file_x'] : $vbphrase['also_delete_template_x']), $module['filename']) . '</label>');
	}

	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);
}

// ##### Do Remove Module #####################################################
if ($_POST['do'] == 'doremovemodule')
{
	$modid = $vbulletin->input->clean_gpc('p', 'modid', TYPE_INT);
	$removefile = $vbulletin->input->clean_gpc('p', 'removefile', TYPE_INT);

	$module = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE modid = $modid
	");

	if (!$module['modid'])
	{
		print_stop_message('invalid_x_specified', $vbphrase['module']);
	}

	if ($module['inctype'] == 'php_file')
	{
		if ($removefile)
		{
			@unlink(DIR . '/modules/' . $module['filename']);
		}

		if ($module['identifier'])
		{
			// Get the settings
			$varnames = array();
			$modsettings = $db->query_read("
				SELECT varname
				FROM " . TABLE_PREFIX . "adv_setting
				WHERE grouptitle = 'adv_portal_$module[identifier]'
			");
			while ($modsetting = $db->fetch_array($modsettings))
			{
				$varnames[] = $modsetting['varname'];
			}

			if (!empty($varnames))
			{
				$dupevar = array();
				$checkdupe = $db->query_read("
					SELECT varname
					FROM " . TABLE_PREFIX . "adv_setting
					WHERE grouptitle != 'adv_portal_$module[identifier]'
						AND varname IN('" . implode("', '", $varnames) . "')
				");
				while ($dupes = $db->fetch_array($checkdupe))
				{
					$dupevar[] = $dupes['varname'];
				}

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "adv_setting
					WHERE varname IN('" . implode("', '", $varnames) . "')
						AND grouptitle = 'adv_portal_$module[identifier]'
				");

				$varnames = array_diff($varnames, $dupevar);

				// Kill the setting phrases
				$killphrase = array();
				if (!empty($varnames))
				{
					foreach ($varnames AS $pvarname)
					{
						$killphrase[] = 'setting_' . $pvarname . '_title';
						$killphrase[] = 'setting_' . $pvarname . '_desc';
					}

					$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname IN('" . implode("', '", $killphrase) . "')");
				}
			}
		}
	}
	else if ($module['inctype'] == 'template' AND $removefile)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "template
			WHERE title = 'adv_portal_" . $db->escape_string($module['filename']) . "'
		");
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_do_remove_module')) ? eval($hook) : false;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_modules WHERE modid = $modid");
	update_module_cache();
	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listmodules', 0);
}

// ##### List Pages ###########################################################
if ($_REQUEST['do'] == 'listpages')
{
	?>
	<script type="text/javascript">
	function js_page_jump(pageid)
	{
		action = eval("document.cpform.p" + pageid + ".options[document.cpform.p" + pageid + ".selectedIndex].value");
		switch (action)
		{
			case 'edit':
				paction = 'editpage';
			break;
			case 'copy':
				paction = 'copypage';
			break;
			case 'remove':
				paction = 'removepage';
			break;
			case 'addchildpage':
				paction = 'newpage';
			break;
		}
		document.cpform.reset();

		window.location = "vba_cmps_admin.php?do=" + paction + "&pageid=" + pageid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
	}
	</script>

	<?php

	print_form_header('vba_cmps_admin', 'doorder');
	print_table_header($vbphrase['edit_pages'], 5);
	print_cells_row(array(
		$vbphrase['title'],
		$vbphrase['controls'],
		$vbphrase['display_order'],
		$vbphrase['identifier'],
		$vbphrase['page_type']
	), 1);

	$diroptions = array(
		'edit' => $vbphrase['edit'],
		'copy' => $vbphrase['copy'],
		'remove' => $vbphrase['delete'],
		'addchildpage' => $vbphrase['add_child_page']
	);

	$pages = cache_cmps_pages();

	foreach ($pages AS $pageid => $page)
	{
		$inactive = '';
		if (!$page['active'])
		{
			$inactive = ' (' . $vbphrase['inactive'] . ')';
			$page['title'] = '<strike>' . $page['title'] . '</strike>';
		}

		print_cells_row(array(
			'<strong>' . str_repeat('--', ($page['level'] - 1)) . ' <a href="vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpage&amp;pageid=' . $page['pageid'] . '">' . $page['title'] . '</a></strong>' . $inactive . '</div>',
			'<div style="white-space: nowrap"><select name="p' . $page['pageid'] . '" onchange="js_page_jump(' . $page['pageid'] . ');" class="bginput" tabindex="1">' . construct_select_options($diroptions) . '</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_jump(' . $page['pageid'] . ');" /></div>',
			'<input type="text" class="bginput" name="order[' . $page['pageid'] . ']" size="3" title="' . $vbphrase['edit_display_order'] . '" value="' . $page['displayorder'] . '" tabindex="1" />',
			$page['name'],
			$vbphrase[$page['type']]
		));
	}

	print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 5);

}

// ##### Re-Order Pages #######################################################
if ($_POST['do'] == 'doorder')
{
	foreach ($_POST['order'] AS $pageid => $disorder)
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_pages SET
				displayorder = " . intval($disorder) . "
			WHERE pageid = " . intval($pageid)
		);
	}

	update_page_cache();

	define('CP_REDIRECT', 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listpages');
	print_stop_message('saved_display_order_successfully');
}

// ##### Add / Edit Page ######################################################
if ($_REQUEST['do'] == 'addpage' OR $_REQUEST['do'] == 'editpage' OR $_REQUEST['do'] == 'copypage')
{
	if ($_REQUEST['do'] == 'addpage' AND !$_REQUEST['type'])
	{
		print_stop_message('adv_portal_must_choose_x_type', $vbphrase['page']);
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'chtype' => TYPE_STR,
		'pageid' => TYPE_INT,
		'parentpage' => TYPE_INT
	));

	if (!isset($type))
	{
		$type = $vbulletin->input->clean_gpc('r', 'type', TYPE_STR);
	}

	?>
	<script type="text/javascript">
	<!--

	function js_check_default(grouptitle, varname)
	{
		document.vbform[ "usedefault[" + grouptitle + "][" + varname + "]" ].checked=false
	}

	function js_page_tools(tool)
	{
		action = eval("document.vbform.tool_" + tool + ".options[document.vbform.tool_" + tool + ".selectedIndex].value");
		switch (action)
		{
			case 'copypage':
				page = 'copypage';
			break;
			case 'removepage':
				page = 'removepage';
			break;
			case 'addchildpage':
				page = 'newpage';
			break;

			case 'chtype_template':
				page = 'editpage&chtype=template';
			break;
			case 'chtype_html_file':
				page = 'editpage&chtype=html_file';
			break;
			case 'chtype_module':
				page = 'editpage&chtype=module';
			break;
			case 'chtype_php_file':
				page = 'editpage&chtype=php_file';
			break;
			case 'chtype_bb_code':
				page = 'editpage&chtype=bb_code';
			break;
		}
		document.vbform.reset();

		window.location = "vba_cmps_admin.php?do=" + page + "&pageid=<?php echo $vbulletin->GPC['pageid']; ?>&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
	}

	function js_template_edit(tempname)
	{
		thisstyleid = eval("document.vbform.edittemp.options[document.vbform.edittemp.selectedIndex].value");
		document.vbform.reset();

		window.location = "vba_cmps_admin.php?do=edittemp&type=page&thisstyleid=" + thisstyleid + "&tempname=" + tempname +"&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";
	}

	-->
	</script>

	<?php

	$pages = construct_page_structure($pagecache, 0);

	require_once(DIR . '/includes/adminfunctions_template.php');

	if ($vbulletin->GPC['chtype'])
	{
		$type = $vbulletin->GPC['chtype'];
	}

	$pagetypes = array(
		'chtype_module' => $vbphrase['module'],
		'chtype_php_file' => $vbphrase['php_file'],
		'chtype_template' => $vbphrase['template'],
		'chtype_html_file' => $vbphrase['html_file'],
		'chtype_bb_code' => $vbphrase['bb_code']
	);

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_page_start')) ? eval($hook) : false;

	// ##### Editing or Copying page
	if ($_REQUEST['do'] == 'editpage' OR $_REQUEST['do'] == 'copypage')
	{
		// Page Settings
		$page['advanced'] = unserialize($page['advanced']);
		$page['meta'] = unserialize($page['meta']);
		$page['modules'] = unserialize($page['modules']);

		if (!isset($type))
		{
			$type = $page['type'];
		}

		// Editing the page
		if ($_REQUEST['do'] == 'editpage')
		{
			$headertitle = $vbphrase['edit_page'] . ': <span class="normal">' . $page['title'] . ' (id: ' . $page['pageid'] . ')</span>';
		}
		// Copying the page
		else
		{
			$headertitle = $vbphrase['copy_page'] . ': ' . $page['title'];

			$pagenames = array();
			$getpages = $db->query_read("
				SELECT name
				FROM " . TABLE_PREFIX . "adv_pages
				WHERE name LIKE '" . $db->escape_string($page['name']) . "%'
			");
			while ($npages = $db->fetch_array($getpages))
			{
				$pagenames[] = $npages['name'];
			}

			// Add a number onto the end of the page name
			$foundname = false;
			$namecount = 1;
			while (!$foundname)
			{
				$namecount++;
				$newname = $page['name'] . $namecount;
				if (!in_array($page['name'] . $namecount, $pagenames))
				{
					$page['name'] = $newname;
					$foundname = true;
				}
			}
		}
	}
	// ##### Adding New page
	else
	{
		$headertitle = $vbphrase['add_page'] . ': ' . $vbphrase[$type];

		$modulecache = cache_cmps_modules();

		foreach ($modulecache AS $modid => $modinfo)
		{
			if ($modinfo['inctype'] == 'custom')
			{
				$cmodid = $modid;
			}
		}

		$page = array(
			'active' => 1,
			'useshell' => 1,
			'parentid' => $vbulletin->GPC['parentpage'],
			'advanced' => array(
				'allow_html' => 1,
				'allow_smilies' => 1,
				'allow_image_code' => 1
			),
			'modules' => array(
				1 => array(),
				2 => array($cmodid => 1),
				3 => array()
			)
		);

	}

	echo '<form action="vba_cmps_admin.php" name="vbform" method="post"' . iif($type == 'bb_code', ' onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(0, 0)"') . '>
		<input type="hidden" name="do" value="' . iif($_REQUEST['do'] == 'editpage', 'doeditpage', 'doaddpage') . '" />
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />
	';

	if ($vbulletin->session->vars['sessionhash'])
	{
		echo '<input type="hidden" name="s" value="' . htmlspecialchars($vbulletin->session->vars['sessionhash']) . '" />';
	}

	print_table_start();
	print_table_header($headertitle);
	construct_hidden_code('page[type]', $type);

	if ($_REQUEST['do'] == 'copypage')
	{
		print_description_row(construct_phrase($vbphrase['copying_x_note'], strtolower($vbphrase['page']), $page['title']));
		print_table_break();
		print_table_break();
	}
	else if ($_REQUEST['do'] == 'editpage')
	{
		construct_hidden_code('pageid', $page['pageid']);

		// Changing the page type
		if ($vbulletin->GPC['chtype'])
		{
			$type = $vbulletin->GPC['chtype'];
			$page['template'] = '';

			print_description_row(
				construct_phrase($vbphrase['change_x_type'], $vbphrase['page']),
				0, 2, 'thead'
			);
			print_description_row(construct_phrase(
				$vbphrase['change_x_type_note'],
				$vbphrase['page'],
				$vbphrase[$page['type']],
				$vbphrase[$type]
			));
		}
		// Not changing the type
		else
		{
			// Page tools
			print_description_row(
				construct_phrase($vbphrase['x_tools'], $vbphrase['page']),
				0, 2, 'thead'
			);
			print_label_row(
				$vbphrase['select_an_action'],
				'<select name="tool_def" onchange="js_page_tools(\'def\');" class="bginput">' .
					construct_select_options(array(
						'' => $vbphrase['please_select_one'],
						'-------' => array(
							'copypage' => $vbphrase['copy'],
							'removepage' => $vbphrase['delete'],
							'addchildpage' => $vbphrase['add_child_page']
						)
					)) .
				'</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_tools(\'def\');" />',
				'', 'top', '', true
			);

			unset($pagetypes['chtype_' . $type]);

			print_label_row(
				construct_phrase($vbphrase['change_x_type'], $vbphrase['page']),
				'<select name="tool_chtype" onchange="js_page_tools(\'chtype\');" class="bginput">' .
					construct_select_options(array(0 => $vbphrase['please_select_one'], '-------' => $pagetypes)) .
				'</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_page_tools(\'chtype\');" />'
			);

			// Template options
			if ($type == 'template')
			{
				cache_styles();

				$styles = array();
				foreach ($stylecache AS $sid => $sinfo)
				{
					$styles[$sid] = $sinfo['title'];
				}
				print_label_row(
					construct_phrase($vbphrase['edit_template_for_x_in_style'], $vbphrase['page']),
					'<select name="edittemp" onchange="js_template_edit(\'' . $page['template'] . '\');" class="bginput">' .
						construct_select_options(array(0 => $vbphrase['please_select_one'], '-------' => $styles)) .
					'</select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="js_template_edit(\'' . $page['template'] . '\');" />'
				);
			}
		}
		print_table_break();
	}

	print_table_break();
	print_table_break();
	print_table_header($vbphrase['main_options']);

	print_input_row($vbphrase['page_title'], 'page[title]', $page['title']);

	if ($page['name'] == 'home')
	{
		construct_hidden_code('page[name]', 'home');
	}
	else
	{
		print_input_row($vbphrase['page_identifier'] . '<div class="smallfont">' . construct_phrase($vbphrase['page_identifier_example'], $vba_options['portal_homeurl'], $vba_options['portal_pagevar']), 'page[name]', $page['name']);
	}

	print_input_row($vbphrase['display_order'] . '<div class="smallfont">' . $vbphrase['display_order_page_desc'] . '</div>', 'page[displayorder]', $page['displayorder']);

	print_input_row($vbphrase['meta_keywords'], 'page[meta][keywords]', $page['meta']['keywords']);
	print_input_row($vbphrase['meta_description'], 'page[meta][description]', $page['meta']['description']);

	$pagesel = fetch_page_select_array($vbphrase['none']);

	print_select_row(
		$vbphrase['parent_page'] . '<div class="smallfont">' . $vbphrase['parent_page_desc'] . '</div>',
		'page[parentid]',
		$pagesel,
		$page['parentid']
	);

	cache_styles();
	$stylesel = array();
	foreach($stylecache AS $style)
	{
		$stylesel[$style['styleid']] = str_repeat('--', ($style['depth'])) . ' ' . $style['title'];
	}

	print_select_row(
		$vbphrase['custom_style_for_this_page'] . '<div class="smallfont">' . $vbphrase['custom_style_for_this_page_desc'] . '</div>',
		'page[styleid]',
		array(0 => $vbphrase['use_default_style'], '----------' => $stylesel),
		$page['styleid']
	);

	print_yes_no_row($vbphrase['page_active'], 'page[active]', $page['active']);

	if ($type AND $type != 'module')
	{
		print_description_row(
			construct_phrase(
				$vbphrase['x_y_options'],
				$vbphrase['page'],
				$vbphrase[$type]
			),
			false, 2, 'thead'
		);

		switch ($type)
		{
			// ##### BB Code Page
			case 'bb_code':

				print_cp_text_editor('page');

			break;

			// Template Page
			case 'template':
				print_input_row($vbphrase['template_title'] . '<div class="smallfont">' . $vbphrase['temlate_title_desc'] . '</div>', 'page[template]', $page['template']);

				print_new_template_box();

			break;

			// PHP File Page
			case 'php_file':
				print_input_row($vbphrase['path_to_file'], 'page[template]', $page['template']);
				print_yes_no_row($vbphrase['clean_file_output'], 'page[cleanoutput]', $page['cleanoutput']);
			break;

			// HTML File Page
			case 'html_file':
				print_input_row($vbphrase['path_to_file'], 'page[template]', $page['template']);
				construct_hidden_code('page[cleanoutput]', 0);
			break;

			default:
				($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_page_switch_type')) ? eval($hook) : false;

		}
		print_middle_submit_row('', 2, iif($type == 'bb_code' OR $type == 'template', 'page'));

		print_table_break();
		print_table_break();

		// Module Shell Template
		print_table_header($vbphrase['module_wrapper_template_options']);
		print_description_row('<span class="smallfont">' . $vbphrase['options_apply_to_module_wrapper'] . '</span>', 0, 2, 'tfoot');
		print_yes_no_row(construct_phrase($vbphrase['use_module_wrapper_template'], $vbphrase['page']), 'page[useshell]', $page['useshell']);
		print_input_row($vbphrase['custom_content_title'], 'page[custom_title]', $page['custom_title']);
		print_input_row($vbphrase['title_row_colspan'], 'page[colspan]', $page['colspan']);
		print_textarea_row($vbphrase['form_code'], 'page[formcode]', $page['formcode']);
	}

	print_middle_submit_row();
	print_table_break();
	print_table_break();

	// ##### Copy module layout
	if (!empty($pagecache))
	{
		$pageselect = fetch_page_select_array($vbphrase['none']);

		print_table_header($vbphrase['copy_module_layout_from_another_page']);
		print_select_row($vbphrase['choose_a_page_to_copy_layout_from'], 'modlayout', $pageselect);
		print_table_break();
	}

	// ##### Modules
	$colphrase = fetch_column_phrases(array_values($vba_options['portal_column_array']));

	$modcache = array();
	$getmods = $db->query_read("
		SELECT modid, title, active, inctype
		FROM " . TABLE_PREFIX . "adv_modules
		ORDER BY title, modid
	");
	while ($mod = $db->fetch_array($getmods))
	{
		if (!$mod['active'])
		{
			$mod['inactive'] = ' <i>(' . $vbphrase['inactive'] . ')</i>';
			$mod['title'] = '<strike>' . $mod['title'] . '</strike>';
		}

		$modcache[$mod['modid']] = $mod;
	}

	$modcolsize = sizeof($vba_modcols);

	$movetosel = array('-1' => $vbphrase['move_to'] . ':', 0 => '----------');
	foreach ($vba_modcols AS $colid => $coltitle)
	{
		$movetosel[$colid] = $colphrase[$coltitle . '_column'];
	}

	// Active modules - Sort them here, then print them after the inactive ones
	$actmodbits = '';
	$activemods = array();
	if (!empty($page['modules']))
	{
		$colcount = 0;
		$actmodbits = '<tr>';
		foreach ($vba_modcols AS $vba_col => $col_phrase)
		{
			$colcount++;
			$actmodbits .= '<td width="' . round(100 / $modcolsize) . '%" class="" valign="top">
				<table width="100%" cellspacing="0" cellpadding="4" class="tborder">
					<tr>
						<td class="tfoot" colspan="2"><strong>' . $colphrase[$col_phrase . '_column'] . '</strong></td>
					</tr>';


			// See if the column has mods like this since we could have a deleted module in the layout
			$colhasmods = false;
			if (!empty($page['modules'][$vba_col]))
			{
				$actmodbits .= '
						<tr>
							<td class="thead">' . $vbphrase['title'] . '</td>
							<td class="thead">' . $vbphrase['order'] . '</td>
						</tr>';

				foreach ($page['modules'][$vba_col] AS $pmodid => $modorder)
				{
					$pmod =& $modcache[$pmodid];
					$activemods[] = $pmodid;

					// Nothing in the cache, so it must be a deleted module
					if (empty($pmod))
					{
						continue;
					}

					$colhasmods = true;

					$moveselect = '<select name="modpos[' . $pmodid . '][col]" class="bginput" tabindex="1">
						<option value="' . $vba_col . '">' . $vbphrase['move_to'] . ':</option>
						<optgroup label="----------"></optgroup>
					';

					foreach ($vba_modcols AS $colid => $coltitle)
					{
						$moveselect .= '<option value="' . $colid . '">' . $colphrase[$coltitle . '_column'] . '</option>';
					}

					$moveselect .= '</select>';

					exec_switch_bg();

					if ($pmod['inctype'] == 'custom')
					{
						if ($type == 'module')
						{
							$pmod['title'] = $vbphrase['custom_page_content_integrate_desc'];
						}
						else
						{
							$pmod['title'] = construct_phrase($vbphrase['custom_page_content_desc'], $vbphrase[$type]);
						}
					}

					$actmodbits .= '<tr>
						<td class="' . $bgclass . '" colspan="2">
							<strong>' . $pmod['title'] . '</strong>' . $pmod['inactive'] . '
						</td>
						</tr>
						<tr>
						<td class="' . $bgclass . '">
							<div>' . $moveselect . '</div>
							<div class="smallfont"><input type="checkbox" id="remove_' . $pmodid . '" name="removemods[]" value="' . $pmodid . '" /><label for="remove_' . $pmodid . '">' . $vbphrase['remove'] . '</label></div>
						</td>
						<td class="' . $bgclass . '" valign="top"><input type="text" name="modpos[' . $pmodid . '][order]" size="3" class="bginput" value="' . $modorder . '" tabindex="1" /></td>
					</tr>';
				}
			}

			if (!$colhasmods)
			{
				$actmodbits .= '<tr><td class="alt1">' . $vbphrase['no_modules'] . '</td></tr>';
			}

			$actmodbits .= '</table></td>';


			if ($colcount == 3)
			{
				$colcount = 0;
				$actmodbits .= '</tr><tr>';
			}
		}

		while ($colcount < 3)
		{
			$colcount++;
			$actmodbits .= '</td><td>';
		}
		$actmodbits .= '</tr><tr>';
	}

	// ##### Inactive modules
	print_table_header($vbphrase['inactive_modules'], 1);

	$inactivemods = array_diff(array_keys($modcache), $activemods);

	if (empty($inactivemods))
	{
		print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['modules']));
	}
	else
	{
		$movetosel = array(0 => $vbphrase['move_to'] . ':');
		foreach ($vba_modcols AS $colid => $coltitle)
		{
			$movetosel['----------'][$colid] = $colphrase[$coltitle . '_column'];
		}

		$inactdiv = '';
		$inactdivend = '';
		$inactwidth = '100';
		$inactclass = '';
		$inactpadding = ' style="padding:0"';
		if (sizeof($inactivemods) > 5)
		{
			$inactdiv = '<div style="height:150px; overflow:auto;" align="center">';
			$inactwidth = '97';
			$inactdivend = '</div>';
			$inactclass = ' class="tborder"';
		}

		echo '<tr><td class="alt1" valign="top"' . $inactpadding . '>' . $inactdiv;
		echo '<table width="' . $inactwidth . '%" cellspacing="0" cellpadding="4"' . $inactclass . '>';
		print_cells_row(array($vbphrase['title'], $vbphrase['move_to'], $vbphrase['order']), true);
		foreach ($inactivemods AS $imodid)
		{
			$imod =& $modcache[$imodid];
			print_cells_row(array(
				$imod['title'] . $imod['inactive'],
				'<select name="modpos[' . $imodid . '][col]" class="bginput" tabindex="1">' .
					construct_select_options($movetosel, -1) .
				'</select>',
				'<input type="text" name="modpos[' . $imodid . '][order]" size="3" class="bginput" value="" tabindex="1" />'
			));
		}

		echo '</table>' . $inactdivend . '</td></tr>';
	}
	print_table_break();

	// ##### Active modules
	print_table_header($vbphrase['modules_enabled'], $modcolsize);
	if ($actmodbits)
	{
		echo $actmodbits;
	}
	else
	{
		print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['modules']), false, $modcolsize);
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_page_modules')) ? eval($hook) : false;

	print_middle_submit_row($vbphrase['save'], $modcolsize);

	print_table_break();
	print_table_break();

	// ##### Usergroup Permissions
	$page['userperms'] = explode(',', $page['userperms']);
	print_table_header($vbphrase['usergroup_permissions']);
	print_label_row(
		$vbphrase['here_specify_which_usergroups_access_page'],
		'<input name="checkall_userperms" value="1" onclick="check_all_array(this, \'userperms\');" type="checkbox" id="checkall_userperms" /> <label for="checkall_userperms">' . $vbphrase['all_yes'] . '</label>',
		'thead',
		'middle'
	);

	foreach ($vbulletin->usergroupcache AS $groupid => $usergroup)
	{
		if ((trim($page['userperms']) AND in_array($usergroup['usergroupid'], $page['userperms']))
			OR $_REQUEST['do'] == 'addpage'
		)
		{
			$usergroup['checked'] = 1;
		}
		print_checkbox_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', $usergroup['checked']);
	}
	print_middle_submit_row();

	print_table_break();
	print_table_break();

	// ##### Advanced settings & module options
	print_table_header('<span style="float:' . $stylevar['right'] . '"><label for="allbox">' . $vbphrase['all_default'] . ' <input id="allbox" name="allbox" onclick="check_all_array(this, \'usedefault\');" type="checkbox" /></label></span> ' . $vbphrase['advanced_options']);
	print_description_row($vbphrase['advanced_options_description']);

	echo '</table><div style="padding:4px"></div>';
	print_table_start(false);

	print_adv_setting_group('page');
	print_table_break();

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_add_edit_page_end')) ? eval($hook) : false;

	print_submit_row();
}

// ##### Do Add / Edit Page ###################################################
if ($_POST['do'] == 'doaddpage' OR $_POST['do'] == 'doeditpage')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'page' => TYPE_ARRAY,
		'modpos' => TYPE_ARRAY,
		'setting' => TYPE_ARRAY,
		'usedefault' => TYPE_ARRAY,
		'userperms' => TYPE_ARRAY,
		'pageid' => TYPE_INT,
		'message' => TYPE_STR,
		'wysiwyg' => TYPE_BOOL,
		'removemods' => TYPE_ARRAY,
		'modlayout' => TYPE_INT,
		'thisstyleid' => TYPE_ARRAY_INT,
		'template' => TYPE_STR
	));
	
	$page =& $vbulletin->GPC['page'];
	$setting =& $vbulletin->GPC['setting'];
	$pageid =& $vbulletin->GPC['pageid'];

	$notices = array();

	// ##### Error Checking
	if ($_POST['do'] == 'doeditpage' AND !$pageid)
	{
		print_stop_message('adv_portal_suhosin');
	}

	if ($checkidentifier = $db->query_first("SELECT pageid FROM " . TABLE_PREFIX . "adv_pages WHERE name = '" . $db->escape_string($page['name']) . "' AND pageid != $pageid"))
	{
		print_stop_message('adv_portal_duplicate_identifier', $vbphrase['page'], $page['name']);
	}

	if ($_POST['do'] == 'doeditpage' AND $page['parentid'] == $pageid)
	{
		print_stop_message('adv_portal_cant_parent_page_itself', $vbphrase['page'], $page['name']);
	}

	if (!trim($page['title']))
	{
		print_stop_message('adv_portal_must_enter_x_for_page', $vbphrase['title']);
	}

	if (!trim($page['name']))
	{
		print_stop_message('adv_portal_must_enter_x_for_page', $vbphrase['identifier']);
	}

	if ($page['type'] == 'php_file' OR $page['type'] == 'html_file')
	{
		if (!is_file($page['template']))
		{
			print_stop_message('adv_portal_invalid_file_path', $vbphrase[$page['type']]);
		}
	}
	// ##### End Error Checking

	$page['meta'] = serialize($page['meta']);

	// BB Code page
	if ($page['type'] == 'bb_code')
	{
		// Kill the wordwrap setting to avoid problems with HTML links/images
		$vbulletin->options['wordwrap'] = 0;

		if ($vbulletin->GPC['wysiwyg'])
		{
			require_once(DIR . '/includes/functions_wysiwyg.php');
			$vbulletin->GPC['message'] = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
		}

		$page['template'] = $vbulletin->GPC['message'];
	}

	// Cache all settings
	$adv_opts = array();
	$getadv_settings = $db->query_read("
		SELECT varname, value, grouptitle, optioncode, serialize
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle LIKE 'adv_portal%'
	");
	while ($adv_settings = $db->fetch_array($getadv_settings))
	{
		$adv_opts[$adv_settings['grouptitle']][$adv_settings['varname']] = $adv_settings;

		if ($adv_settings['optioncode'] == 'forumselect'
			 AND !isset($setting[$adv_settings['grouptitle']][$adv_settings['varname']])
			 AND !isset($vbulletin->GPC['usedefault'][$adv_settings['grouptitle']][$adv_settings['varname']])
		)
		{
			$setting[$adv_settings['grouptitle']][$adv_settings['varname']] = array();
		}
	}

	// Find threadids and add them
	if ($_POST['do'] == 'doeditpage')
	{
		$pageadv = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = $pageid");
		$pageadv['advanced'] = unserialize($pageadv['advanced']);

		if (!empty($pageadv['advanced']))
		{
			foreach ($pageadv['advanced'] AS $modident => $modopt)
			{
				if ($modopt['portal_threadids'] AND !$vbulletin->GPC['usedefault'][$modident]['portal_threadids'])
				{
					$adv_setting[$modident]['portal_threadids'] = $modopt['portal_threadids'];
				}
			}
		}
	}

	// ##### Process the new settings
	if (!empty($setting))
	{
		foreach ($setting AS $identifier => $modopts)
		{
			foreach ($modopts AS $varname => $value)
			{
				if ($vbulletin->GPC['usedefault'][$identifier][$varname] OR $adv_opts[$identifier][$varname]['value'] == $value)
				{
					continue;
				}

				// Navigation module additional links
				if ($varname == 'portal_navigation_addpages')
				{
					$value = format_sitenav_links($value);
				}

				$adv_setting[$identifier][$varname] = $value;
			}
		}
	}

	$page['advanced'] = serialize($adv_setting);

	// ##### Modules
	$page['modules'] = '';
	$layout = array();

	// copy from page
	if ($vbulletin->GPC['modlayout'])
	{
		$pagelayout = $db->query_first("SELECT modules FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = " . $vbulletin->GPC['modlayout']);
		$pagelayout['modules'] = unserialize($pagelayout['modules']);
		$layout =& $pagelayout['modules'];
	}
	// custom layout
	else if (!empty($vbulletin->GPC['modpos']))
	{
		$layout = format_module_layout($vbulletin->GPC['modpos'], $vbulletin->GPC['removemods']);
	}

	$page['modules'] = serialize($layout);

	// Check to see if custom page content is active
	$customenabled = false;

	if ($page['type'] == 'module')
	{
		// none of these should be set for module pages
		$page['useshell'] = 0;
		$page['custom_title'] = '';
		$page['colspan'] = 0;
		$page['formcode'] = '';
	}
	else
	{
		$cusmod = $vbulletin->db->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = 'custompage'");

		// Just loop through them again since we might be copying from another page
		if (!empty($layout))
		{
			foreach ($layout AS $col => $colmods)
			{
				if (in_array($cusmod['modid'], array_keys($colmods)))
				{
					$customenabled = true;
				}
			}
		}

		if (!$customenabled)
		{
			$notices[] = fetch_error('adv_portal_custom_page_inactive', $vbphrase[$page['type']]);
		}

		if ($page['type'] == 'template')
		{
			insert_new_cmps_templates($page['template']);
		}
	}

	// Permissions
	$page['userperms'] = '';
	if (!empty($vbulletin->GPC['userperms']))
	{
		$page['userperms'] = implode(',', array_keys($vbulletin->GPC['userperms']));
	}

	if ($page['styleid'] == '-1')
	{
		$page['styleid'] = 0;
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_do_add_edit_page')) ? eval($hook) : false;

	$db->query_write(fetch_query_sql($page, 'adv_pages', iif($_POST['do'] == 'doeditpage', 'WHERE pageid = ' . $pageid)));

	if ($_POST['do'] == 'doaddpage')
	{
		$pageid = $db->insert_id();
	}

	rebuild_parents($pageid);

	// Update the homepage cache
	if ($page['name'] == 'home')
	{
		update_homepage_cache();
	}

	update_page_cache();

	if (!empty($notices))
	{
		$printnotice = '<ul>';
		foreach ($notices AS $notice)
		{
			$printnotice .= '<li>' . $notice . '</li>';
		}
		$printnotice .= '</ul>';

		define('CP_BACKURL', 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpage&pageid=' . $pageid);
		print_stop_message('adv_portal_page_saved_but_problems_found', $printnotice);
	}

	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listpages', 0);
}

// ##### Remove Page ##########################################################
if ($_REQUEST['do'] == 'removepage')
{
	$pageid = $vbulletin->input->clean_gpc('r', 'pageid', TYPE_INT);

	$pages = cache_cmps_pages();
	$page =& $pages[$pageid];

	if (!$page['pageid'])
	{
		print_stop_message('invalid_page_specified');
	}

	if ($page['name'] == 'home')
	{
		print_stop_message('adv_portal_cant_remove_default');
	}

	print_form_header('vba_cmps_admin', 'doremovepage');
	construct_hidden_code('pageid', $page['pageid']);
	print_table_header($vbphrase['confirm_deletion'], 3);

	// Find any sub-pages
	$pagenotes = '';
	$childpagearray = construct_page_structure($pages, $pageid);

	if (!empty($childpagearray))
	{
		$pagesel = '<option value="-1">' . $vbphrase['delete'] . '</option>
			<optgroup label="--------"></optgroup>
			<optgroup label="' . $vbphrase['select_new_parent'] . '">
				<option value="0">' . $vbphrase['none'] . '</option>
		';

		$pagesleft = array_diff(array_keys($pages), array_keys($childpagearray));
		foreach ($pagesleft AS $selpageid)
		{
			$pagesel .= '<option value="' . $selpageid . '">' . str_repeat('--', ($pages[$selpageid]['level'] - 1)) . ' ' . $pages[$selpageid]['title'] . '</option>';
		}

		$pagenotes = '<br /><br />' . $vbphrase['page_contains_following_sub_pages'] . '<br /><table>';
		foreach ($childpagearray AS $cpageid => $cpage)
		{
			if ($cpage['level'] == 1)
			{
				$pagenotes .= '<tr><td style="padding-top: 4px"><select name="subpages[' . $cpageid . ']">' . $pagesel . '</select>&nbsp;</td><td style="padding-top: 4px">' . $cpage['title'] . '</td></tr>';
			}
			else
			{
				$pagenotes .= '<tr><td> </td><td class="smallfont">' . str_repeat('--', ($cpage['level'] - 1)) . ' ' . $cpage['title'] . '</td></tr>';
			}
		}

		$pagenotes .= '</table>';
	}

	// Integrated pages
	$integrated = false;
	$integopt =& $vba_options['portal_integrate'];

	if (!empty($integopt))
	{
		foreach ($integopt AS $inttype => $integration)
		{
			if (is_array($integration))
			{
				if (in_array($page['name'], array_values($integration)))
				{
					$integrated = true;
				}
			}
		}
	}

	print_description_row(construct_phrase($vbphrase['are_you_sure_delete_page_called_x'] . $pagenotes, $page['title']), false, 3);

	// Integration
	if ($integrated)
	{
		$childpagearray[] = $page['pageid'];

		$customselect = print_integration_page_select(0, 'name', $vbphrase['remove'], $childpagearray);

		print_table_break();
		print_table_header($vbphrase['current_integrated_pages'], 3);
		print_description_row($vbphrase['delete_page_integrated_files'], false, 3);
		print_cells_row(array(
			$vbphrase['filename'] . ' / THIS_SCRIPT',
			'',
			$vbphrase['action']
		), true);
		print_current_integration_row('vbfilenames', $customselect);
		print_current_integration_row('otfilenames', $customselect);
		print_current_integration_row('thisscript', $customselect);
		print_table_break();
	}

	print_submit_row($vbphrase['delete'], '', 3, $vbphrase['go_back']);
}

// ##### Do Remove Page #######################################################
if ($_POST['do'] == 'doremovepage')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'pageid' => VAR_INT,
		'subpages' => VAR_ARRAY_INT,
		'vbfilenames_data' => TYPE_ARRAY,
		'otfilenames_data' => TYPE_ARRAY,
		'thisscript_data' => TYPE_ARRAY
	));

	if (!$vbulletin->GPC['pageid'])
	{
		print_stop_message('invalid_page_specified');
	}

	$integopt =& $vba_options['portal_integrate'];

	process_deleted_integration('vbfilenames');
	process_deleted_integration('otfilenames');
	process_deleted_integration('thisscript');

	$vbulletin->GPC['vba_page'] = $integopt['vba_page'];
	$vbulletin->GPC['vbfilenames'] = $integopt['vbfilenames'];
	$vbulletin->GPC['otfilenames'] = $integopt['otfilenames'];
	$vbulletin->GPC['thisscript'] = $integopt['thisscript'];

	build_integration_plugin();

	// Update sub-page parents & find the ones to remove
	$killpages = array();
	if (!empty($vbulletin->GPC['subpages']))
	{
		$pagecache = cache_cmps_pages();
		foreach ($vbulletin->GPC['subpages'] AS $subpageid => $subpagepar)
		{
			// Kill it and it's sub-pages
			if ($subpagepar == '-1')
			{
				$killpages = array_merge(
					array_keys(construct_page_structure($pagecache, $subpageid)),
					$killpages
				);
				$killpages[] = $subpageid;
			}
			// New parent
			else
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET parentid = $subpagepar WHERE pageid = $subpageid");
			}
		}
	}

	if (!empty($killpages))
	{
		$killpages[] = $vbulletin->GPC['pageid'];
		$killpages = implode(',', $killpages);
	}
	else
	{
		$killpages = $vbulletin->GPC['pageid'];
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_pages WHERE pageid IN($killpages)");

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_do_remove_page')) ? eval($hook) : false;

	update_page_cache();

	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listpages', 0);
}

// ##### Download / Upload Module #############################################
if ($_REQUEST['do'] == 'download')
{
	require_once(DIR . '/includes/adminfunctions_template.php');

	print_form_header('vba_cmps_admin', 'uploadmodule', true);

	// Upload module
	print_table_header($vbphrase['upload_module']);
	print_description_row($vbphrase['main_options'], 0, 2, 'thead');
	print_upload_row($vbphrase['select_module_upload'], 'modfile');

	print_yes_no_row($vbphrase['active_set_to_no_disable'], 'module[active]', 1);

	cache_styles();

	$stylesel = array();
	foreach($stylecache AS $style)
	{
		$stylesel[$style['styleid']] = construct_depth_mark($style['depth'], '--') . $style['title'];
	}

	print_select_row(
		$vbphrase['style_to_install_to'],
		'thisstyleid[]',
		$stylesel,
		'',
		false,
		(sizeof($stylecache) <= 6 ? sizeof($stylecache) : 6),
		true
	);

	print_label_row(
		$vbphrase['usergroups'],
		'<input name="checkall_userperms" checked="checked" value="1" onclick="check_all_array(this, \'userperms\');" type="checkbox" id="checkall_userperms" /> <label for="checkall_userperms">' . $vbphrase['all_yes'] . '</label>',
		'thead',
		'middle'
	);

	foreach ($vbulletin->usergroupcache AS $groupid => $usergroup)
	{
		print_checkbox_row($usergroup['title'], 'userperms[' . $usergroup['usergroupid'] . ']', 1);
	}

	print_submit_row($vbphrase['submit'], '');

	// Download module
	print_form_header('vba_cmps_admin', 'downloadmodule');
	print_table_header($vbphrase['download_module']);

	$modulecache = cache_cmps_modules();

	$modbits = '<span style="white-space: nowrap">';
	foreach ($modulecache AS $modid => $module)
	{
		if ($module['inctype'] == 'custom')
		{
			continue;
		}
		$modbits .= '<div><input id="' . $module['modid'] . '" name="modid" type="radio" value="' . $module['modid'] . '" /> <label for="' . $module['modid'] . '">' . $module['title'] . '</label></div>';
	}
	$modbits .= '</span>';

	print_label_row(
		$vbphrase['tool_downloads_module'] .
			'<fieldset class="fieldset" style="width:40%; padding-top: 10px" align="' . $stylevar['left'] . '">
				<legend>' . $vbphrase['download_file_type'] . '</legend>
				<input type="radio" name="downloadformat" value="xml" id="dlf_xml" checked="checked"><label for="dlf_xml">' . $vbphrase['dot_xml'] . '</label><br />
				<input type="radio" name="downloadformat" value="module" id="dlf_module"><label for="dlf_module">' . $vbphrase['dot_module_serialized_data'] . '</label>
			</fieldset>',
		$modbits, '', 'top', NULL, true
	);

	print_submit_row($vbphrase['download'], '', 3);
}

// ##### Upload Module ########################################################
if ($_POST['do'] == 'uploadmodule')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'filename' => TYPE_NOHTML,
		'haderrors' => TYPE_INT,
		'identifier' => TYPE_NOHTML,
		'module_serial' => TYPE_STR,
		'modulefilename' => TYPE_NOHTML,
		'overwrite_filename' => TYPE_INT,
		'overwrite_template' => TYPE_INT,
		'thisstyleid' => TYPE_ARRAY_INT,
		'updateall' => TYPE_INT,
		'userperms' => TYPE_ARRAY,
		'userperms_serial' => TYPE_STR
	));

	if (!is_writable('./modules/'))
	{
		print_stop_message('adv_portal_moddir_notwritable');
	}

	$module =& $_POST['module'];

	if (!$vbulletin->GPC['haderrors'])
	{
		$modfile =& $_FILES['modfile'];
		@chmod('./modules', 0777);
		@move_uploaded_file($modfile['tmp_name'], './modules/' . $modfile['name']);
	}
	else
	{
		$modfile['name'] = $vbulletin->GPC['modulefilename'];
	}

	$file_ext = strtolower(substr($modfile['name'], (strrpos($modfile['name'], '.') + 1)));

	// Incorrect extension
	if ($file_ext != 'xml' AND $file_ext != 'module' AND substr($modfile['name'], -11) != '.module.php')
	{
		@unlink('./modules/' . $modfile['name']);
		print_stop_message('adv_portal_invalid_modfile');
	}

	$modfilepath = './modules/' . $modfile['name'];

	$moduleinfo = file_read($modfilepath);

	// Open it up and get the info
	if ($file_ext == 'xml')
	{
		require_once(DIR . '/includes/class_xml.php');
		$xmlobj = new vB_XML_Parser($moduleinfo);

		$moduleinfo = $xmlobj->parse();
	}
	else
	{
		$moduleinfo = unserialize($moduleinfo);
	}

	if ($vbulletin->GPC['haderrors'])
	{
		$vbulletin->GPC['module_serial'] = unserialize($vbulletin->GPC['module_serial']);
		$module =& $vbulletin->GPC['module_serial'];

		$vbulletin->GPC['userperms'] = unserialize($vbulletin->GPC['userperms_serial']);
	}
	else
	{
		// For old CMPS modules
		if (!is_array($moduleinfo['module']))
		{
			$moduleinfo['module'] = unserialize($moduleinfo['module']);
		}

		$module = array_merge($moduleinfo['module'], $module);
	}

	if (empty($module))
	{
		@unlink('./modules/' . $modfile['name']);
		print_stop_message('adv_portal_invalid_modfile');
	}

	if ($vbulletin->GPC['identifier'])
	{
		$module['identifier'] = $vbulletin->GPC['identifier'];
	}

	if ($vbulletin->GPC['filename'])
	{
		$module['filename'] = $vbulletin->GPC['filename'];
	}

	$moderrors = array();

	// ##### PHP file erorr checks
	if ($module['inctype'] == 'php_file')
	{
		// Filename
		if (!$vbulletin->GPC['overwrite_filename'] AND is_file('./modules/' . $module['filename']) AND $moduleinfo['file'])
		{
			$moderrors['duplicate_filename'] = $module['filename'];
		}

		// Identifier
		if ($checkidentifier = $db->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = '" . $db->escape_string($module['identifier']) . "'"))
		{
			$moderrors['duplicate_module_identifier'] = $module['identifier'];
		}
	}

	// ##### Templates
	// For old CMPS modules
	if (!is_array($moduleinfo['templates']))
	{
		$moduleinfo['templates'] = unserialize($moduleinfo['templates']);
	}

	if (!empty($moduleinfo['templates']) AND !$vbulletin->GPC['haderrors'])
	{

		if (empty($vbulletin->GPC['thisstyleid']))
		{
			print_stop_message('adv_portal_choose_style');
		}

		$currenttemplates = array();
		$checktemps = $db->query_read("
			SELECT title
			FROM " . TABLE_PREFIX . "template
			WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "')
				AND styleid IN(" . implode(',', $vbulletin->GPC['thisstyleid']) . ")
		");
		while ($template = $db->fetch_array($checktemps))
		{
			$moderrors['overwrite_templates'][] = $template['title'];
		}
		$db->free_result($checktemps);
		unset($template);
	}

	// ##### Have Errros
	if (sizeof($moderrors))
	{
		$moderrorkeys = array_keys($moderrors);
		print_form_header('vba_cmps_admin', 'uploadmodule');

		foreach ($vbulletin->GPC['thisstyleid'] AS $styleid)
		{
			// construct_hidden_code() won't allow multiple inputs with the same name
			echo '<input type="hidden" name="thisstyleid[]" value="' . $styleid . '" />';
		}

		construct_hidden_code('updateall', $vbulletin->GPC['updateall']);
		construct_hidden_code('haderrors', 1);
		construct_hidden_code('modulefilename', $modfile['name']);
		construct_hidden_code('userperms_serial', serialize($vbulletin->GPC['userperms']));
		construct_hidden_code('module_serial', serialize($module));

		if ($vbulletin->GPC['identifier'] AND !in_array('duplicate_module_identifier', $moderrorkeys))
		{
			construct_hidden_code('identifier', $identifier);
		}

		if ($vbulletin->GPC['filename'] AND !in_array('duplicate_filename', $moderrorkeys))
		{
			construct_hidden_code('filename', $vbulletin->GPC['filename']);
		}

		if ($vbulletin->GPC['overwrite_template'])
		{
			construct_hidden_code('overwrite_template', $vbulletin->GPC['overwrite_template']);
		}

		if ($vbulletin->GPC['overwrite_filename'])
		{
			construct_hidden_code('overwrite_filename', $vbulletin->GPC['overwrite_filename']);
		}

		print_table_header($vbphrase['error']);

		// Print the errors
		foreach ($moderrors AS $phrase => $value)
		{
			print_description_row($vbphrase[$phrase], '', 2, 'thead');

			switch ($phrase)
			{
				// ##### Overwrite templates?
				case 'overwrite_templates':
					print_yes_no_row(construct_phrase($vbphrase[$phrase . '_desc'], '<strong>' . implode('<br />', $value)) . '</strong>', 'overwrite_template', 0);
				break;

				// ##### Duplicate filename
				case 'duplicate_filename':
					if ($vbulletin->GPC['haderrors'])
					{
						$curfilesel[$vbulletin->GPC['overwrite_filename']] = ' checked="checked"';
					}
					else
					{
						$curfilesel['2'] = ' checked="checked"';
					}
					print_label_row(
						construct_phrase($vbphrase[$phrase . '_desc'], $value),
						'<div class="smallfont">
							<input type="radio" name="overwrite_filename" id="orf_2" value="2" ' . $curfilesel['2'] . '/><label for="orf_2">' . $vbphrase['use_current_file_instead'] . '</label><br />
							<input type="radio" name="overwrite_filename" id="orf_1" value="1" ' . $curfilesel['1'] . '/><label for="orf_1">' . $vbphrase['overwrite_file_with_new_file'] . '</label><br />
							<input type="radio" name="overwrite_filename" id="orf_0" value="0" ' . $curfilesel['0'] . '/><label for="orf_0">' . $vbphrase['rename_to_filename_entered_below'] . '</label><br />
							<input type="text" size="35" name="filename" class="bginput" value="' . $value . '" />
						</div>'
					);
				break;

				// ##### Duplicate Identifier
				case 'duplicate_module_identifier':
					print_input_row(construct_phrase($vbphrase[$phrase . '_desc'], $value), 'identifier', $value);
				break;
			}
		}
		print_submit_row();
	}
	// ##### No errors, so let's process the module
	else
	{
		// Usergroup permissions
		if (!empty($vbulletin->GPC['userperms']))
		{
			$ugperms = array();
			foreach ($vbulletin->GPC['userperms'] AS $usergroupid => $allow)
			{
				if ($allow)
				{
					$ugperms[] = $usergroupid;
				}
			}
			$module['userperms'] = implode(',', $ugperms);
		}

		// Process templates
		if (!empty($moduleinfo['templates']) AND ($vbulletin->GPC['overwrite_template'] OR (empty($moderrors['overwrite_templates']))))
		{
			require_once(DIR . '/includes/adminfunctions_template.php');

			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode('\',\'', array_keys($moduleinfo['templates'])) . "')
					AND styleid IN(" . implode(', ', $vbulletin->GPC['thisstyleid']) . ")
			");

			$templateinsert = '';

			if (!empty($vbulletin->GPC['thisstyleid']))
			{
				foreach ($vbulletin->GPC['thisstyleid'] AS $installstyleid)
				{
					foreach ($moduleinfo['templates'] AS $title => $template)
					{
						$templateinsert .= "(
							'" . $db->escape_string($title) . "',
							'" . $db->escape_string(compile_template($template)) . "',
							'" . $db->escape_string($template) ."',
							'$installstyleid',
							'template',
							" . TIMENOW . ",
							'" . $db->escape_string($vbulletin->userinfo['username']) . "',
							'" . $vbulletin->options['templateversion'] . "',
							'adv_cmps'
						),";
					}
				}

				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "template
						(title, template, template_un, styleid, templatetype, dateline, username, version, product)
					VALUES
						" . substr($templateinsert, 0, (strlen($templateinsert) - 1))
				);
			}

			build_all_styles(0, 0);
		}

		// ##### Module settings
		// For old CMPS modules
		if (!is_array($moduleinfo['settings']))
		{
			$moduleinfo['settings'] = unserialize($moduleinfo['settings']);
		}

		// Clean output (from old CMPS modules)
		if (isset($module['cleanoutput']))
		{
			if ($module['cleanoutput'])
			{
				$module['options'] += $vba_php_modint['clean_output'];
			}
			unset($module['cleanoutput']);
		}

		// ##### Settings
		if (!empty($moduleinfo['settings']))
		{
			foreach ($moduleinfo['settings'] AS $varname => $setting)
			{
				$db->query_write("
					INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
						(languageid, varname, text, fieldname, product)
					VALUES (
						0,
						'setting_" . $varname . "_title',
						'" . $db->escape_string($setting['title']) ."',
						'vbsettings',
						'adv_cmps'
				)");
				$db->query_write("
					INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
						(languageid, varname, text, fieldname, product)
					VALUES (
						0,
						'setting_" . $varname . "_desc',
						'" . $db->escape_string($setting['description']) . "',
						'vbsettings',
						'adv_cmps'
				)");

				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "adv_setting
						(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
					VALUES (
						'$varname',
						'adv_portal_$module[identifier]',
						'" . $db->escape_string($setting['value']) . "',
						'" . $db->escape_string($setting['defaultvalue']) . "',
						'" . $db->escape_string($setting['optioncode']) . "',
						'$setting[displayorder]',
						'$setting[serialize]'
				)");
			}
		}

		// For Dynamics modules
		unset($module['description']);
		unset($module['useredit']);

		// Insert module
		$db->query_write(fetch_query_sql($module, 'adv_modules'));
		$modid = $db->insert_id();

		// Write module file
		if ($module['inctype'] == 'php_file')
		{
			if ($vbulletin->GPC['overwrite_filename'] != 2)
			{
				if ($fp = fopen('./modules/' . $module['filename'], 'w'))
				{
					fputs($fp, $moduleinfo['file']);
					fclose($fp);
				}
			}
		}

		// Delete the .module file
		unlink('./modules/' . $modfile['name']);

		update_module_cache();
		build_adv_settings();

		print_form_header('vba_cmps_admin', 'modulepages');
		construct_hidden_code('modid', $modid);
		print_table_header($vbphrase['vbulletin_message']);
		print_description_row(fetch_error('adv_portal_module_saved_add_to_pages', $vbulletin->session->vars['sessionurl']));

		print_submit_row($vbphrase['continue'], '', 2, '', construct_button_code($vbphrase['go_back'], 'vba_cmps_admin.php?do=download'));
	}
}

// ##### Edit Module Threads (show forums) ####################################
if ($_REQUEST['do'] == 'listforums')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'identifier' => TYPE_NOHTML,
		'pageid' => TYPE_STR
	));

	$identifier =& $vbulletin->GPC['identifier'];

	if ($vbulletin->GPC['pageid'] == 'newpage')
	{
		print_stop_message('adv_portal_threads_save_page');
	}
	$vbulletin->GPC['pageid'] = intval($vbulletin->GPC['pageid']);

	if ($vbulletin->GPC['pageid'])
	{
		$page = $db->query_first("
			SELECT advanced
			FROM " . TABLE_PREFIX . "adv_pages
			WHERE pageid = " . $vbulletin->GPC['pageid']
		);
		$page['advanced'] = unserialize($page['advanced']);
		$threadids = $page['advanced']['adv_portal_' . $identifier]['portal_threadids'];
	}
	if (!$vbulletin->GPC['pageid'] OR empty($threadids))
	{
		$threadids = fetch_module_threadids($vbulletin->GPC['identifier']);
	}

	if (!empty($threadids))
	{
		print_form_header('vba_cmps_admin', 'removethreads');
		construct_hidden_code('identifier', $vbulletin->GPC['identifier']);
		construct_hidden_code('pageid', $vbulletin->GPC['pageid']);
		print_table_header($vbphrase['current_selected_threads'], 3);
		print_cells_row(array($vbphrase['remove'], $vbphrase['title'], $vbphrase['forum']), 1, '', -2);

		$getthreads = $db->query_read("
			SELECT threadid, title, forumid, firstpostid
			FROM " . TABLE_PREFIX . "thread
			WHERE threadid IN(" . implode(',', array_keys($threadids)) . ")
			ORDER BY lastpost DESC
		");
		while ($thread = $db->fetch_array($getthreads))
		{
			$class = exec_switch_bg();
			echo '<tr>
				<td align="center" class="' . $class . '" width="40"><input name="threadids[' . $thread['threadid'] . ']" value="' . $thread['firstpostid'] . '" type="checkbox"></td>
				<td class="' . $class . '"><a href="' . $vbulletin->options['bburl'] . '/showthread.php?' . $vbulletin->session->vars['sessionurl'] . 't=' . $thread['threadid'] . '" target="_blank">' . $thread['title'] . '</a></td>
				<td class="' . $class . '" width="250"><a href="' . $vbulletin->options['bburl'] . '/forumdisplay.php?' . $vbulletin->session->vars['sessionurl'] . 'f=' . $thread['forumid'] . '" target="_blank">' . $vbulletin->forumcache[$thread['forumid']]['title'] . '</a></td></tr>';
		}
		print_submit_row($vbphrase['remove'], '', 3);
	}

	print_form_header('', '');
	print_table_header($vbphrase['select_new_threads']);
	print_description_row($vbphrase['to_begin_selecting_threads'], 0, 2, 'thead');

	foreach ($vbulletin->forumcache AS $forum)
	{
		if (!($forum['options'] & $vbulletin->bf_misc_forumoptions['cancontainthreads']))
		{
			print_description_row('<i>' . str_repeat('--', $forum['depth']) . $forum['title'] . '</i>', 0, 2, 'alt1');
		}
		else
		{
			print_description_row(str_repeat('--', $forum['depth']) . ' <a href="vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=threadids&amp;identifier=' . $vbulletin->GPC['identifier'] . '&amp;forumid=' . $forum['forumid'] . '&amp;pageid=' . $vbulletin->GPC['pageid'] . '">' . $forum['title'] . '</a>', 0, 2, 'alt2');
		}
	}

	print_table_footer();
}

// ##### Show Threads in Forum ################################################
if ($_REQUEST['do'] == 'threadids')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'currentpage' => TYPE_INT,
		'forumid' => TYPE_INT,
		'gotopagenumber' => TYPE_STR,
		'identifier' => TYPE_NOHTML,
		'page' => TYPE_INT,
		'pageid' => TYPE_INT,
		'threadids' => TYPE_ARRAY_INT
	));

	// ##### Do submit threadids
	if ($_POST['dosubmit'])
	{
		$threadarray = ($vbulletin->GPC['pageid']) ? array() : fetch_module_threadids($vbulletin->GPC['identifier']);

		$posts = $db->query_read("
			SELECT threadid, firstpostid
			FROM " . TABLE_PREFIX . "thread
			WHERE threadid IN(" . implode(',', array_keys($vbulletin->GPC['threadids'])) . ")
		");
		while ($post = $db->fetch_array($posts))
		{
			$threadarray[$post['threadid']] = $post['firstpostid'];
		}

		// Updating for specific page only
		if ($vbulletin->GPC['pageid'])
		{
			$page = $db->query_first("
				SELECT name, advanced
				FROM " . TABLE_PREFIX . "adv_pages
				WHERE pageid = " . $vbulletin->GPC['pageid']
			);
			$page['advanced'] = unserialize($page['advanced']);

			$page['advanced']['adv_portal_' . $vbulletin->GPC['identifier']]['portal_threadids'] = $threadarray;

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_pages SET
					advanced = '" . $db->escape_string(serialize($page['advanced'])) . "'
				WHERE pageid = " . $vbulletin->GPC['pageid']
			);

			// Update the homepage cache
			if ($page['name'] == 'home')
			{
				update_homepage_cache();
			}
		}

		// Updating the module
		else
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting SET
					value = '" . $db->escape_string(serialize($threadarray)) . "'
				WHERE grouptitle = 'adv_portal_" . $vbulletin->GPC['identifier'] . "'
					AND varname = 'portal_threadids'
			");

			build_adv_settings();
		}

		print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listforums&identifier=' . $vbulletin->GPC['identifier'] . '&pageid=' . $vbulletin->GPC['pageid']);
	}

	// ##### Browsing forum for threads
	else
	{
		$wherequery = array('forumid = ' . $vbulletin->GPC['forumid']);
		$pagedata = fetch_page_data('thread');

		print_form_header('vba_cmps_admin', 'threadids');
		construct_hidden_code('forumid', $vbulletin->GPC['forumid']);
		construct_hidden_code('identifier', $vbulletin->GPC['identifier']);
		construct_hidden_code('pageid', $vbulletin->GPC['pageid']);

		if ($vbulletin->GPC['gotopagenumber'])
		{
			switch ($vbulletin->GPC['gotopagenumber'])
			{
				case $vbphrase['last'] . ' ':
					$_REQUEST['page'] = $pagedata['pagecount'];
				break;
				case ' ' . $vbphrase['first']:
					$_REQUEST['page'] = 1;
				break;
				case '< ' . $vbphrase['prev']:
					$_REQUEST['page'] = $vbulletin->GPC['currentpage'] - 1;
				break;
				case $vbphrase['next'] . ' >':
					$_REQUEST['page'] = $vbulletin->GPC['currentpage'] + 1;
				break;
			}
			$pagedata = fetch_page_data('thread');
		}
		construct_hidden_code('currentpage', $pagedata['pagenumber']);

		// Construct the pagenav
		if ($pagedata['pagecount'] > 1)
		{
			if ($pagedata['pagenumber'] != 1)
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&laquo; ' . $vbphrase['first'] . '" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="&lt; ' . $vbphrase['prev'] . '" /> ';
			}

			$i = 0;
			$thispage = ($pagedata['pagenumber'] + 5 > $pagedata['pagecount']) ? $pagedata['pagenumber'] - 5 : $pagedata['pagecount'] - 9;

			if ($thispage < 0)
			{
				$thispage = 0;
			}

			$pageprint = ($pagedata['pagecount'] >= 9) ? 9 : $pagedata['pagecount'];

			while ($i++ < $pageprint)
			{
				$thispage++;
				$pagenav .= '<input class="button" name="page" type="submit" value="' . iif($thispage > 9, $thispage, ' ' . $thispage . ' ') . '"' . iif($pagedata['pagenumber'] == $thispage, ' disabled="disabled"') . ' /> ';
			}

			if ($pagedata['pagenumber'] != $pagedata['pagecount'])
			{
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['next'] . ' &gt;" /> ';
				$pagenav .= '<input class="button" name="gotopagenumber" type="submit" value="' . $vbphrase['last'] . ' &raquo;" />';
			}
		}

		print_table_header('<span style="float:' . $stylevar['right'] . '">' . $pagenav . '</span>' . $vbulletin->forumcache[$vbulletin->GPC['forumid']]['title'], 2, 0, '', $stylevar['left']);

		// First page, so get the current selected threads
		if (!$vbulletin->GPC['page'])
		{
			if ($vbulletin->GPC['pageid'])
			{
				$page = $db->query_first("SELECT advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = " . $vbulletin->GPC['pageid']);
				$page['advanced'] = unserialize($page['advanced']);
				$vbulletin->GPC['threadids'] = $page['advanced']['adv_portal_' . $vbulletin->GPC['identifier']]['portal_threadids'];
			}

			if (empty($vbulletin->GPC['threadids']))
			{
				$vbulletin->GPC['threadids'] = fetch_module_threadids($vbulletin->GPC['identifier']);
			}
		}

		$selectedthreads = array_keys($vbulletin->GPC['threadids']);

		unset($threadid);

		$getthreads = $db->query_read("
			SELECT threadid, title, postusername, firstpostid, pollid
			FROM " . TABLE_PREFIX . "thread
			WHERE forumid = " . $vbulletin->GPC['forumid'] . "
			ORDER BY lastpost DESC
			LIMIT " . ($pagedata['minlimit'] - 1) . ", $pagedata[perpage]
		");
		if ($db->num_rows($getthreads))
		{
			while ($thread = $db->fetch_array($getthreads))
			{
				unset($vbulletin->GPC['threadids'][$thread['threadid']]);
				$class = exec_switch_bg();
				echo '<tr>
					<td align="center" class="' . $class . '"><input ' . iif(in_array($thread['threadid'], $selectedthreads), 'checked="checked"') . ' type="checkbox" name="threadids[' . $thread['threadid'] . ']" value="' . $thread['firstpostid'] . '" /></td>
					<td class="' . $class . '" width="100%">' . iif($thread['pollid'], $vbphrase['poll'] . ': ') . construct_link_code($thread['title'], $vbulletin->options['bburl'] . '/showthread.php?t=' . $thread['threadid'], 1) . '</td>
				</tr>';
			}

			// Print hidden inputs for any not listed above
			if (!empty($vbulletin->GPC['threadids']))
			{
				foreach ($vbulletin->GPC['threadids'] AS $threadid => $firstpostid)
				{
					construct_hidden_code('threadids[' . $threadid . ']', $firstpostid);
				}
			}

			print_table_footer(2, '<input type="submit" class="button" name="dosubmit" value="' . $vbphrase['submit'] . '" />');
		}
		else
		{
			print_description_row(construct_phrase($vbphrase['no_x_to_display'], $vbphrase['threads']));
			print_table_footer();
		}
	}
}

// ##### Remove Module Threads ################################################
if ($_POST['do'] == 'removethreads')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'identifier' => TYPE_NOHTML,
		'pageid' => TYPE_INT,
		'threadids' => TYPE_ARRAY_INT
	));

	if ($vbulletin->GPC['pageid'])
	{
		$page = $db->query_first("SELECT name, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE pageid = " . $vbulletin->GPC['pageid']);
		$page['advanced'] = unserialize($page['advanced']);
		$pagethreads =& $page['advanced']['adv_portal_' . $vbulletin->GPC['identifier']]['portal_threadids'];

		$ptids = array();
		if (empty($pagethreads))
		{
			$ptids = fetch_module_threadids($identifier);
		}
		else
		{
			$ptids = $pagethreads;
		}

		// Unset selected threads
		foreach ($vbulletin->GPC['threadids'] AS $threadid => $postid)
		{
			unset($ptids[$threadid]);
		}

		$pagethreads = $ptids; // resets the $page['advanced'] variable since $pagethreads is a reference

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_pages SET
				advanced = '" . serialize($page['advanced']) . "'
			WHERE pageid = " . $vbulletin->GPC['pageid']
		);

		// Update the homepage cache
		if ($page['name'] == 'home')
		{
			update_homepage_cache();
		}
	}
	else
	{
		$curthreads = fetch_module_threadids($vbulletin->GPC['identifier']);

		// Unset selected threads
		foreach ($vbulletin->GPC['threadids'] AS $threadid => $postid)
		{
			unset($curthreads[$threadid]);
		}

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_setting SET
				value = '" . serialize($curthreads) . "'
			WHERE grouptitle = 'adv_portal_" . $vbulletin->GPC['identifier'] . "'
				AND varname = 'portal_threadids'
		");
	}

	build_adv_settings();

	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=listforums&identifier=' . $vbulletin->GPC['identifier'] . '&pageid=' . $vbulletin->GPC['pageid']);
}

// ##### Quick Permissions ####################################################
if ($_REQUEST['do'] == 'permissions')
{
	print_form_header('vba_cmps_admin', 'dopermissions');
	print_table_header($vbphrase['pages']);

	$allgroupids = array_keys($vbulletin->usergroupcache);

	// ##### Pages
	$ppcache = cache_cmps_pages();

	foreach ($ppcache AS $pid => $page)
	{
		$page['userperms'] = explode(',', $page['userperms']);

		print_label_row(
			$page['title'],
			'<input name="checkall_pages_' . $pid . '" value="1" onclick="check_all_array(this, \'pageperms\', ' . $pid . ');" type="checkbox" id="checkall_pages_' . $pid . '" ' . iif(!array_diff($allgroupids, $page['userperms']), 'checked="checked" ') . '/><label for="checkall_pages_' . $pid . '">' . $vbphrase['check_all'] . '</label>',
			'thead',
			'middle'
		);

		foreach ($vbulletin->usergroupcache AS $ugroup)
		{
			print_checkbox_row($ugroup['title'], 'pageperms[' . $pid . '][' . $ugroup['usergroupid'] . ']', iif(in_array($ugroup['usergroupid'], $page['userperms']), 1));
		}
	}
	print_middle_submit_row('', 2, false, true, 'center');

	print_table_break();
	print_table_break();
	print_table_break();

	// ##### Modules
	print_table_header($vbphrase['modules']);

	$modcache = array();
	$getmods = $db->query_read("
		SELECT modid, title, userperms
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE inctype != 'custom'
		ORDER BY title, modid
	");
	while ($mods = $db->fetch_array($getmods))
	{
		$modcache[$mods['modid']] = $mods;
	}

	foreach ($modcache AS $modid => $mod)
	{
		$mod['userperms'] = explode(',', $mod['userperms']);
		print_label_row(
			$mod['title'],
			'<input name="checkall_mods_' . $modid . '" value="1" onclick="check_all_array(this, \'modperms\', ' . $modid . ');" type="checkbox" id="checkall_mods_' . $modid . '" ' . iif(!array_diff($allgroupids, $mod['userperms']), 'checked="checked" ') . '/><label for="checkall_mods_' . $modid . '">' . $vbphrase['check_all'] . '</label>',
			'thead',
			'middle'
		);

		foreach ($vbulletin->usergroupcache AS $ugroup)
		{
			print_checkbox_row($ugroup['title'], 'modperms[' . $modid . '][' . $ugroup['usergroupid'] . ']', iif(in_array($ugroup['usergroupid'], $mod['userperms']), 1));
		}
	}

	print_submit_row();

}

// ##### Save Quick Permissions ###############################################
if ($_POST['do'] == 'dopermissions')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'pageperms' => TYPE_ARRAY,
		'modperms' => TYPE_ARRAY
	));

	// Pages
	$getpages = $db->query_read("SELECT pageid FROM " . TABLE_PREFIX . "adv_pages");
	while ($page = $db->fetch_array($getpages))
	{
		$pagegroups = '';
		if (!empty($vbulletin->GPC['pageperms'][$page['pageid']]))
		{
			$pagegroups = implode(',', array_keys($vbulletin->GPC['pageperms'][$page['pageid']]));
		}

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_pages SET
				userperms = '" . $pagegroups . "'
			WHERE pageid = $page[pageid]
		");
	}

	// Modules
	$getmods = $db->query_read("SELECT modid FROM " . TABLE_PREFIX . "adv_modules");
	while ($mod = $db->fetch_array($getmods))
	{
		$modgroups = '';
		if (!empty($vbulletin->GPC['modperms'][$mod['modid']]))
		{
			$modgroups = implode(',', array_keys($vbulletin->GPC['modperms'][$mod['modid']]));
		}

		$db->query_write("
			UPDATE " . TABLE_PREFIX . "adv_modules SET
				userperms = '$modgroups'
			WHERE modid = $mod[modid]
		");
	}

	update_page_cache();
	update_homepage_cache();
	update_module_cache();

	print_cp_redirect('vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=permissions');

}

// ##### Integration ##########################################################
if ($_REQUEST['do'] == 'integrate')
{
	$validext = array('php', 'php3', 'php4', 'php5', 'phtml', 'html', 'htm');
	$skipfilenames = array('ajax', 'attachment', 'cron', 'external', 'global', 'image', 'login', 'payment_gateway', 'threadrate');
	$filenames = array();
	$validpages = array();

	// Get a list of filenames from the vB folder
	$directory = opendir('./');
	while ($filename = readdir($directory))
	{
		$dotpos = strrpos($filename, '.');
		$fileext = substr($filename, ($dotpos + 1));
		$filenoext = substr($filename, 0, $dotpos);

		if (in_array($fileext, $validext) AND !in_array($filenoext, $skipfilenames))
		{
			$filenames[$filename] = $filename;
		}
	}
	closedir($directory);
	asort($filenames);

	// What's this page do?
	print_table_start();
	print_table_header($vbphrase['integration']);
	print_description_row('<div style="padding: 6px">' . $vbphrase['integration_allows_you_include_cmps'] . '</div>');
	print_table_break();

	$integopt =& $vba_options['portal_integrate'];

	$customselect = print_integration_page_select($integopt['vba_page']);

	if (!empty($integopt['vbfilenames']) OR !empty($integopt['otfilenames']) OR !empty($integopt['thisscript']))
	{
		$showcurrent = true;
	}

	// Set from print_integration_page_select() above
	if (empty($validpages))
	{
		print_description_row(fetch_error('adv_portal_no_valid_integration_pages'));
		print_table_footer();
	}

	if ($showcurrent OR !empty($validpages))
	{
		print_table_footer();

		$integratephrase = array(
			'vbfilenames' => 'vbulletin_files_to_integrate',
			'otfilenames' => 'other_filenames_to_integrate',
			'thisscript' => 'this_script_integration_method'
		);

		// Current Integrated Pages
		if ($showcurrent)
		{
			print_form_header('vba_cmps_admin', 'updateintegrate');
			construct_hidden_code('vba_page', $integopt['vba_page']);
			print_table_header($vbphrase['current_integrated_pages'], 3);
			print_current_integration_row('vbfilenames');
			print_current_integration_row('otfilenames');
			print_current_integration_row('thisscript');
			print_submit_row($vbphrase['submit'], $vbphrase['reset'], 3);
		}

		if (!empty($validpages))
		{
			// Page to use
			print_form_header('vba_cmps_admin', 'integatepages');
			print_table_header($vbphrase['integate_new_pages']);
			print_description_row($vbphrase['cmps_page_to_integrate_with'], false, 2, 'thead');
			print_label_row(
				'<div class="smallfont">' . $vbphrase['cmps_page_to_integrate_with_desc'] . '</div>',
				'<select name="vba_page" style="font-weight:bold" class="bginput" tabindex="1">'
					. $customselect .
				'</select>'
			);

			// vB Files
			print_description_row($vbphrase['vbulletin_files_to_integrate'], false, 2, 'thead');
			print_label_row('<div class="smallfont">' . $vbphrase['vbulletin_files_to_integrate_desc'] . '<br /><br />' . $vbphrase['note_integrates_any_file_with_same_name'] . '</div>', '<select name="vbfilenames[]" class="bginput" style="width:300px" size="12" multiple="multiple" class="bginput" tabindex="1">' .
				construct_select_options($filenames) . '</select>'
			);

			// Other files
			print_description_row($vbphrase['other_filenames_to_integrate'], false, 2, 'thead');
			print_textarea_row(
				'<div class="smallfont">' . $vbphrase['other_filenames_to_integrate_desc'] . '<br /><br />' . $vbphrase['note_integrates_any_file_with_same_name'] . '</div>',
				'otfilenames',
				$selectedot,
				8, 45, true, false
			);

			// THIS_SCRIPT method
			print_description_row($vbphrase['this_script_integration_method'], false, 2, 'thead');
			print_textarea_row(
				'<div class="smallfont">' . construct_phrase($vbphrase['this_script_integration_method_desc'], $stylevar['left']) . '</div>',
				'thisscript_list',
				'',
				8, 45, true, false
			);

			print_submit_row($vbphrase['continue']);
		}
	}
}

// ##### Integrate Pages - Select Page ########################################
if ($_POST['do'] == 'integatepages')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'vba_page' => TYPE_INT,
		'vbfilenames' => TYPE_ARRAY,
		'otfilenames' => TYPE_STR,
		'thisscript_list' => TYPE_STR
	));

	$pagecache = cache_cmps_pages();

	$vbnames =& $vbulletin->GPC['vbfilenames'];
	$othernames =& $vbulletin->GPC['otfilenames'];
	$ts_list =& $vbulletin->GPC['thisscript_list'];

	if (empty($vbnames) AND !$othernames AND !$ts_list)
	{
		print_stop_message('adv_portal_no_files_to_integrate');
	}

	$integopt =& $vba_options['portal_integrate'];
	$gpc_pagename = $pagecache[$vbulletin->GPC['vba_page']]['name'];

	print_form_header('vba_cmps_admin', 'dointegrate');
	print_table_header($vbphrase['integration']);

	construct_hidden_code('vba_page', $vbulletin->GPC['vba_page']);

	print_description_row('<div style="padding: 6px">' . $vbphrase['select_pages_to_integrate_and_save'] . '</div>');
	print_table_break();

	// ##### vB filenames
	if (!empty($vbnames))
	{
		print_description_row($vbphrase['vbulletin_files_to_integrate'], false, 2, 'thead');

		foreach ($vbulletin->GPC['vbfilenames'] AS $vbfilename)
		{
			$selected = ($integopt['vbfilenames'][$vbfilename]) ? $integopt['vbfilenames'][$vbfilename] : $gpc_pagename;
			print_label_row(
				$vbfilename,
				'<select name="vbfilenames_data[' . $vbfilename . ']" style="font-weight:bold" class="bginput" tabindex="1">'
					. print_integration_page_select($selected, 'name') .
				'</select>'
			);
		}
	}

	// ##### Other filenames
	if ($othernames)
	{
		$othernames = explode("\r\n", $othernames);

		if (!empty($othernames))
		{
			print_description_row($vbphrase['other_filenames_to_integrate'], false, 2, 'thead');

			foreach ($othernames AS $otfilename)
			{
				$selected = ($integopt['otfilenames'][$otfilename]) ? $integopt['otfilenames'][$otfilename] : $gpc_pagename;
				print_label_row(
					$otfilename,
					'<select name="otfilenames_data[' . $otfilename . ']" style="font-weight:bold" class="bginput" tabindex="1">'
						. print_integration_page_select($selected, 'name') .
					'</select>'
				);
			}
		}
	}

	// ##### THIS_SCRIPT method
	if (!empty($ts_list))
	{
		$ts_list = explode("\r\n", $ts_list);
		if (!empty($ts_list))
		{
			print_description_row($vbphrase['this_script_integration_method'], false, 2, 'thead');

			foreach ($ts_list AS $ts_value)
			{
				$ts_value = preg_replace('/[^a-z_0-9]/i', '' , $ts_value);

				$selected = ($integopt['thisscript'][$ts_value]) ? $integopt['thisscript'][$ts_value] : $gpc_pagename;
				print_label_row(
					$ts_value,
					'<select name="thisscript_data[' . $ts_value . ']" style="font-weight:bold" class="bginput" tabindex="1">'
						. print_integration_page_select($selected, 'name') .
					'</select>'
				);
			}
		}
	}

	print_submit_row();
}

// ##### Finalize Integration #################################################
if ($_POST['do'] == 'dointegrate' OR $_POST['do'] == 'updateintegrate')
{
	build_integration_plugin();

	define('CP_BACKURL', 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=integrate');
	print_stop_message('adv_portal_integration_successfully_saved');

}

// ##### Edit Template ########################################################
if ($_REQUEST['do'] == 'edittemp')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'thisstyleid' => TYPE_INT,
		'tempname' => TYPE_STR
	));

	$tempname = iif($_REQUEST['type'] != 'page', 'adv_portal_') . $vbulletin->GPC['tempname'];

	$template = $db->query_first("
		SELECT templateid
		FROM " . TABLE_PREFIX . "template
		WHERE title = '" . $db->escape_string($tempname) . "'
			AND styleid = " . $vbulletin->GPC['thisstyleid']
	);

	print_cp_redirect('template.php?' . iif($template['templateid'], 'do=edit&templateid=' . $template['templateid'], 'do=add&dostyleid=' . $vbulletin->GPC['thisstyleid'] . '&title=' . $tempname));

}

// ##### Diagnostics ##########################################################
if ($_REQUEST['do'] == 'diagnostics')
{
	?>

	<style>
	<!--
	.cus_setting_box {
		margin-top:4px;
		padding: 4px;
		color: #000000;
		background-color:#FFFFFF;
		border: solid #FF0000 1px;
		width: 90%;
		font-size: 11px;
		font-weight: bold;
	}

	.cus_setting_box a {
		color: #000000;
		font-size: 11px;
		font-weight: none;
	}

	-->
	</style>

	<?php

	print_form_header('', '');
	print_table_header($vbphrase['diagnostics']);
	print_description_row($vbphrase['version'], false, 2, 'thead');

	$cversion = @file_get_contents('http://license.vbadvanced.com/?p=4', 'r');

	print_description_row(iif($cversion,
		construct_phrase(
			$vbphrase['currently_running_latest_available'],
			$vba_options['portal_version'],
			$cversion,
			iif($cversion == $vba_options['portal_version'],
				$vbphrase['your_vba_version_up_to_date'],
				$vbphrase['newer_version_available']
			)
		),
		$vbphrase['version_info_unavailable'])
	);

	print_description_row(
		construct_link_code(
			construct_phrase($vbphrase['rebuild_x'], $vbphrase['module_cache']),
			'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=buildmods'
		) . ' - ' .
		construct_link_code(
			construct_phrase($vbphrase['rebuild_x'], $vbphrase['page_parentlists']),
			'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=rebuildparents'
		), false, 2, 'tfoot', 'center'
	);

	print_table_break();

	// Make sure CMPS product is active
	if (!$vbulletin->products['adv_cmps'])
	{
		print_table_header($vbphrase['error']);
		print_description_row('<div class="cus_setting_box">' . $vbphrase['cmps_product_inactive'] . '</div>');
		print_table_break();
	}

	// Make sure the plugins are active
	$inactplugins = array();
	$installedplugins = array();
	$pluginkeys = array('adv_cmps_ajaxspacer', 'adv_cmps_cpsmiliewin', 'adv_cmps_incbottom', 'adv_cmps_inctop', 'adv_cmps_integrate_start', 'adv_cmps_init_startup', 'adv_cmps_integrate_output', 'adv_cmps_newpost', 'adv_cmps_newpostsession', 'adv_cmps_template', 'adv_cmps_error', 'adv_cmps_navlinks', 'adv_cmps_lightbox');

	$getplugins = $db->query_read("
		SELECT title, devkey, active
		FROM " . TABLE_PREFIX . "plugin
		WHERE product = 'adv_cmps'
	");
	while ($plugin = $db->fetch_array($getplugins))
	{
		if (!$plugin['active'])
		{
			$inactplugins[] = $plugin['title'];
		}

		$installedplugins[] = $plugin['devkey'];
	}

	// Plugins are missing
	if (array_diff($pluginkeys, $installedplugins))
	{
		print_table_header($vbphrase['error']);
		print_description_row('<div class="cus_setting_box">' . $vbphrase['plugins_missing'] . '</div>');
		print_table_break();
	}

	// Plugins are inactive
	if (!empty($inactplugins))
	{
		$inactivelist = '<ul>';
		
		foreach ($inactplugins AS $inactp)
		{
			$inactivelist .= '<li>' . $inactp . '</li>';
		}
		$inactivelist .= '</ul>';
		
		print_table_header($vbphrase['error']);
		print_description_row('<div class="cus_setting_box">' . construct_phrase($vbphrase['plugins_inactive_x'], $inactivelist) . '</div>');
		print_table_break();
	}

	print_table_header($vbphrase['urls']);

	// Main CMPS URL
	$cmpspathgood = false;
	if (@fopen($vba_options['portal_homeurl'], 'r'))
	{
		$cmpspathgood = true;
	}

	$pathphrase = $vbphrase['okay'];
	$pathclass = 'smallfont';
	if (!$cmpspathgood)
	{
		$pathphrase = fetch_error('adv_portal_invalid_cmps_url', $vba_options['portal_homeurl']);
		$pathclass = 'cus_setting_box';
	}

	print_description_row($vbphrase['main_options'], false, 2, 'thead');
	print_label_row('(<a href="' . $vba_options['portal_homeurl'] . '" target="_blank">' . $vba_options['portal_homeurl'] . '</a>)
		<div style="padding-top: 4px">' . construct_link_code($vbphrase['edit_setting'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifysettings&amp;grouptitle=adv_portal_main') . '</div>',
		'<div class="' . $pathclass . '">' . $pathphrase . '</div>', '', 'top', NULL, 50
	);

	// CMPS URL from page settings
	$psettings = array();
	$pagesettings = $db->query_read("
		SELECT pageid, title, advanced
		FROM " . TABLE_PREFIX . "adv_pages
		WHERE advanced != ''
	");
	while ($page = $db->fetch_array($pagesettings))
	{
		$page['advanced'] = unserialize($page['advanced']);

		$pageurl = $page['advanced']['adv_portal_main']['portal_homeurl'];

		if ($pageurl)
		{
			$cmpspathgood = false;
			$pathclass = 'smallfont';

			if (@fopen($pageurl, 'r'))
			{
				$cmpspathgood = true;
			}

			$pathphrase = $vbphrase['okay'];
			if (!$cmpspathgood)
			{
				$pathclass = 'cus_setting_box';
				$pathphrase = fetch_error('unable_to_open_url');
			}

			print_description_row($vbphrase['page'] . ': ' . $page['title'], false, 2, 'thead');
			print_label_row('(<a href="' . $pageurl . '" target="_blank">' . $pageurl . '</a>)
				<div style="padding-top: 4px">' . construct_link_code($vbphrase['edit_setting'], 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editpage&amp;pageid=' . $page['pageid'] . '&amp;expandgroup=main#sgroup_adv_portal_main') . '</div>',
				'<div class="' . $pathclass . '">' . $pathphrase . '</div>'
			);
		}
	}
	print_table_break();

	// Check that module filenames exist
	print_table_header(construct_phrase($vbphrase['x_modules'], $vbphrase['php_file']));

	$filenames = array();

	$directory = @opendir('./modules');
	while ($modfile = @readdir($directory))
	{
		if (ereg('[^.]+', $modfile) AND $modfile != 'index.html')
		{
			$filenames[] = $modfile;
		}
	}

	@closedir($directory);

	$phpmodules = $db->query_read("
		SELECT modid, title, filename
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE inctype = 'php_file'
	");
	while ($mod = $db->fetch_array($phpmodules))
	{
		$modphrase = $vbphrase['okay'];
		$modclass = 'smallfont';

		if (!in_array($mod['filename'], $filenames))
		{
			$modphrase = $vbphrase['file_not_found'];
			$modclass = 'cus_setting_box';
		}

		print_label_row('<a href="vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editmodule&amp;modid=' . $mod['modid'] . '">' . $mod['title'] . '</a>',
			'<div class="' . $modclass . '">' . $modphrase . '</div>', '', 'top', NULL, 50
		);
	}
	print_table_break();

	// Versions
	$filelocations = array(
		$vbulletin->config['Misc']['admincpdir'] . '/vba_cmps_admin.php',
		$vbulletin->config['Misc']['admincpdir'] . '/vbacmps_install.php',
		'clientscript/vba_cmps_admin.js',
		'includes/vba_cmps_adminfunctions.php',
		'includes/vba_cmps_global.php',
		'includes/vba_cmps_include_bottom.php',
		'includes/vba_cmps_include_template.php',
		'includes/vba_cmps_include_top.php',
		'includes/xml/cpnav_vbacmps.xml',
		'includes/xml/hooks_vbacmps.xml',
		'modules/birthdays.php',
		'modules/currentpoll.php',
		'modules/minicalendar.php',
		'modules/moderate.php',
		'modules/navigation.php',
		'modules/news.php',
		'modules/onlineusers.php',
		'modules/popular_tags.php',
		'modules/recentthreads.php',
		'modules/stats.php',
		'modules/welcomeblock.php'
	);

	$versionlen = strlen($vba_options['portal_version']);

	print_table_header($vbphrase['suspect_file_versions']);

	foreach ($filelocations AS $path)
	{
		$filecontent = @file_get_contents(DIR . '/' . $path);

		$verphrase = $vbphrase['okay'];
		$verclass = 'smallfont';

		if (!$filecontent AND $path != $vbulletin->config['Misc']['admincpdir'] . '/vba_cmps_admin.php')
		{
			$verphrase = $vbphrase['file_not_found'];
			$verclass = 'cus_setting_box';
		}
		else if ($path != 'includes/xml/hooks_vbacmps.xml' AND $path != 'includes/xml/cpnav_vbacmps.xml')
		{
			$versionstart = (strpos($filecontent, '// || vBadvanced CMPS v') + 23);

			// No version found
			if ($versionstart == 23)
			{
				$verphrase = $vbphrase['file_contents_mismatch'];
				$verclass = 'cus_setting_box';
			}
			else
			{
				$fileversion = substr($filecontent, $versionstart, $versionlen);

				if ($fileversion != $vba_options['portal_version'])
				{
					$verphrase = construct_phrase($vbphrase['file_version_mismatch_x_expected_y'], $fileversion, $vba_options['portal_version']);
					$verclass = 'cus_setting_box';
				}
			}
		}

		print_label_row($path, '<div class="' . $verclass . '">' . $verphrase . '</div>', '', 'top', NULL, 50);
	}

	print_table_footer();
}

// ##### Rebuild Parents ######################################################
if ($_REQUEST['do'] == 'rebuildparents')
{
	rebuild_parents(0);

	print_stop_message('adv_portal_x_rebuilt', $vbphrase['page_parentlists']);
}

// ##### Build Modules ########################################################
if ($_REQUEST['do'] == 'buildmods')
{
	update_module_cache();

	print_stop_message('adv_portal_x_rebuilt', $vbphrase['module_cache']);
}

($hook = vBulletinHook::fetch_hook('vba_cmps_admin_end')) ? eval($hook) : false;


// Print footer
if ($_REQUEST['do'] != 'downloadmodule')
{
	if (defined('CP_TEXT_EDITOR'))
	{
		echo '<script type="text/javascript">
		<!--
			// Main vBulletin Javascript Initialization
			vBulletin_init();
		//-->
		</script>';
	}

	print_cp_footer();
}

?>